/** @file tpctacmod.h
 *  @brief Header file for libtpctacmod.
 *  @details libtpctacmod contains functions needed in reading and processing 
 *  PET TAC data for modelling and fitting.
 *  @author Vesa Oikonen
 */
#ifndef _TPCTACMOD_H_
#define _TPCTACMOD_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcli.h"
#include "tpctac.h"
#include "tpcmodels.h"
#include "tpcpar.h"
#include "tpcfunc.h"
/*****************************************************************************/

/*****************************************************************************/
/* litac */
extern int tacIntegrate(TAC *inp, TAC *out, TPCSTATUS *status);
extern int tacInterpolate(
  TAC *inp, TAC *xinp, TAC *tac, TAC *itac, TAC *iitac, TPCSTATUS *status
);
extern int tacInterpolateInto(
  TAC *inp, TAC *tac, TAC *itac, TAC *iitac, TPCSTATUS *status
);
extern int tacInterpolateToEqualLengthFrames(
  TAC *inp, double minfdur, double maxfdur, TAC *tac, TPCSTATUS *status
);
extern int tacDelay(TAC *tac, double dt, int ti, TPCSTATUS *status);
extern double tacAUC(TAC *tac, int ti, double t1, double t2, TPCSTATUS *status);
extern int tacVb(
  TAC *ttac, const int i, TAC *btac, double Vb, const int simVb, const int petVolume,
  TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
/* lisim */
extern int tacInput2sim(TAC *itac, TAC *ttac, TAC *stac, TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* litacrange */
//extern int tacInterpolateCheckStart(TAC *inp, TAC *tac, int forgiving, TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* tacmodelinput */
extern int tacFittime(
  TAC *d, double *startTime, double *endTime, int *first, int *last,
  TPCSTATUS *status
);
extern int tacReadModelingData(
  const char *tissuefile, const char *inputfile1,
  const char *inputfile2, const char *inputfile3,
  double *fitdur, int cutInput, int *fitSampleNr, TAC *tis, TAC *inp,
  TPCSTATUS *status
);
extern int tacReadReference(
  TAC *tis, const char *reference, TAC *ref, int *refIndex, TPCSTATUS *status
);
extern int tacReadModelingInput(
  const char *inputfile1, const char *inputfile2, const char *inputfile3,
  TAC *inp, TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
/* tacfitplot */
extern int tacPlotFitSVG(
  TAC *tac1, TAC *tac2, const char *main_title, 
  const double x1, const double x2, const double y1, const double y2, 
  const char *fname, TPCSTATUS *status
);
extern int tacPlotLineSVG(
  TAC *tac, const char *main_title,
  const double x1, const double x2, const double y1, const double y2,
  const char *fname, TPCSTATUS *status
);
extern int mtgaPlotSVG(
  MTAC *mtac, const char *main_title, const char *fname, TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
/* histplot */
extern int tacPlotHistogramSVG(
  TAC *d, const char *main_title, const double x1, const double x2, const double y1, const double y2,
  const char *fname, TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
/* partac */
extern int tacAllocateWithPAR(TAC *tac, PAR *par, int sampleNr, TPCSTATUS *status);
extern int parAllocateWithTAC(PAR *par, TAC *tac, int parNr, TPCSTATUS *status);
extern int tacToPAR(TAC *tac, PAR *par, TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
#endif /* _TPCTACMOD_H_ */
