#!/bin/bash
#: Title      : test_lhtest
#: Date       : 2023-04-14
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../lhtest$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f bolus.fit ] || [ ! -f bblood.tac ] || [ ! -f bpet.tac ]; then
  printf "FIT1        generic\n" > bolus.fit
  printf "Date:	2023-03-01 20:42:59\n" >> bolus.fit
  printf "Data file:	bolus.dat\n" >> bolus.fit
  printf "Data unit:	g/mL\n" >> bolus.fit
  printf "Time unit:	min\n" >> bolus.fit
  printf "Nr of VOIs:	1\n" >> bolus.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> bolus.fit
  printf "PTAC	0.000	10.000	23	0	7	1313	4010	-11.7	469	-20.2	9.43	-0.895	0.5\n" >> bolus.fit

  printf "12/4/2023 11:03:43  8 2 1 SIM1 O-15\n" > bolus.sif
  printf "      0      30\n" >> bolus.sif
  printf "     30      60\n" >> bolus.sif
  printf "     60     120\n" >> bolus.sif
  printf "    120     180\n" >> bolus.sif
  printf "    180     240\n" >> bolus.sif
  printf "    240     300\n" >> bolus.sif
  printf "    300     420\n" >> bolus.sif
  printf "    420     540\n" >> bolus.sif

  printf "# model := SER3TCM\n" > bolus.par
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	k3[1/min]	Vb[%%]	dT[sec]\n" >> bolus.par
  printf "tac1	0.50	0.25	0	0	0\n" >> bolus.par

  fit2dat -c=0,10,0.02 bolus.fit bolus.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  sim_3tcm bolus.par bolus.bld bolus.bld btissue.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

# Add Vb
  taccalc bolus.bld x 0.05 temp.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  taccalc btissue.dat + temp.bld bpet.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

  simframe bolus.bld bolus.sif bblood.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe bpet.dat bolus.sif bpet.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  tac2svg bolus.svg -l bolus.bld bpet.dat -s bblood.tac bpet.tac

fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Simulated i1TCM data with PET frames on both blood and tissue. \n"
printf " Expected result: Not too far from correct. \n\n"

rm -f sa100.tac bf100.tac t100.par
$PROGRAM -d10 bblood.tac bpet.tac t100.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"





printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
