#!/bin/bash
#: Title      : test_llsqrk2
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../llsqrk2$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f input.fit ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f tg2r33.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f input.tac ] || [ ! -f inputf.tac ]; then
  rm -f simul1.par tissue1.tac simul2.par tissue2.tac
  printf "\n make input TAC \n"
  fit2dat -c=0,420,0.5 input.fit input.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren --silent input.tac 1 blood_artery
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n and also framed version of that \n"
  simframe input.tac frames.dat inputf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

printf "\n simulate TTACs \n"

if [ ! -f simul1.par ]; then
  rm -f tissue1.tac framed1.tac
# Note that K1 unit is needed because not per sec as in input file
  printf "# model := SER3TCM\n" > simul1.par
  printf "Parameters,K1[mL/(min*mL)],K1/k2,k3,k4,k5,k6\n" >> simul1.par
  printf "tac01_500,5,1,0,0,0,0\n" >> simul1.par
  printf "tac02_400,4,1,0,0,0,0\n" >> simul1.par
  printf "tac03_300,3,1,0,0,0,0\n" >> simul1.par
  printf "tac04_200,2,1,0,0,0,0\n" >> simul1.par
  printf "tac05_150,1.5,1,0,0,0,0\n" >> simul1.par
  printf "tac06_100,1.0,1,0,0,0,0\n" >> simul1.par
  printf "tac07_090,0.9,1,0,0,0,0\n" >> simul1.par
  printf "tac08_080,0.8,1,0,0,0,0\n" >> simul1.par
  printf "tac09_070,0.7,1,0,0,0,0\n" >> simul1.par
  printf "tac10_060,0.6,1,0,0,0,0\n" >> simul1.par
  printf "tac11_050,0.5,1,0,0,0,0\n" >> simul1.par
  printf "tac12_040,0.4,1,0,0,0,0\n" >> simul1.par
  printf "tac13_030,0.3,1,0,0,0,0\n" >> simul1.par
  printf "tac14_020,0.2,1,0,0,0,0\n" >> simul1.par
  printf "tac15_015,0.15,1,0,0,0,0\n" >> simul1.par
  printf "tac16_010,0.10,1,0,0,0,0\n" >> simul1.par
  printf "tac17_009,0.09,1,0,0,0,0\n" >> simul1.par
  printf "tac18_008,0.08,1,0,0,0,0\n" >> simul1.par
  printf "tac19_007,0.07,1,0,0,0,0\n" >> simul1.par
  printf "tac20_006,0.06,1,0,0,0,0\n" >> simul1.par
  printf "tac21_005,0.05,1,0,0,0,0\n" >> simul1.par
  printf "tac22_004,0.04,1,0,0,0,0\n" >> simul1.par
  printf "tac23_003,0.03,1,0,0,0,0\n" >> simul1.par
  printf "tac24_002,0.02,1,0,0,0,0\n" >> simul1.par
  printf "tac25_001,0.01,1,0,0,0,0\n" >> simul1.par
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f tissue1.tac ] || [ ! -f simul1.svg ]; then
  rm -f framed1.tac
  sim_3tcm simul1.par input.tac none tissue1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1.svg -l input.tac tissue1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f framed1.tac ] || [ ! -f simul1f.svg ]; then
  simframe tissue1.tac frames.dat framed1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1f.svg -l input.tac framed1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f tissue2.tac ] || [ ! -f framed2.tac ]; then
# Note that K1 unit is needed because not per sec as in input file
  printf "# model := SER3TCM\n" > simul2.par
  printf "Parameters,K1[mL/(min*mL)],K1/k2,k3,k4,k5,k6\n" >> simul2.par
  printf "rtac,1,0.5,0,0,0,0\n" >> simul2.par

  sim_3tcm simul2.par input.tac none tissue2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe tissue2.tac frames.dat framed2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul2f.svg -l input.tac framed2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f posref1.tac ]; then
# Note that K1 unit is needed because not per sec as in input file
  printf "# model := SER3TCM\n" > posref1.par
  printf "Parameters,K1[mL/(min*mL)],k2,k3,k4,k5,k6\n" >> posref1.par
  printf "rtac,6,0,0,0,0,0\n" >> posref1.par

  sim_3tcm posref1.par input.tac none temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe temp.tac frames.dat posref1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y posref1.svg -l input.tac posref1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f posref2.tac ]; then
# Note that K1 unit is needed because not per sec as in input file
  printf "# model := SER3TCM\n" > posref2.par
  printf "Parameters,K1[mL/(min*mL)],k2,k3,k4,k5,k6\n" >> posref2.par
  printf "rtac,0.01,0,0,0,0,0\n" >> posref2.par

  sim_3tcm posref2.par input.tac none temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe temp.tac frames.dat posref2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y posref2.svg -l input.tac posref2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




if [ ! -f correct100.par ]; then
  printf "Parameters	R1	k2[1/min]	WSS\n" > correct100.par
  printf "tac01_500	2.5	5	0\n" >> correct100.par
  printf "tac02_400	2	4	0\n" >> correct100.par
  printf "tac03_300	1.5	3	0\n" >> correct100.par
  printf "tac05_150	0.75	1.5	0\n" >> correct100.par
  printf "tac06_100	0.5	1	0\n" >> correct100.par
  printf "tac07_090	0.45	0.9	0\n" >> correct100.par
  printf "tac08_080	0.4	0.8	0\n" >> correct100.par
  printf "tac09_070	0.35	0.7	0\n" >> correct100.par
  printf "tac10_060	0.3	0.6	0\n" >> correct100.par
  printf "tac11_050	0.25	0.5	0\n" >> correct100.par
  printf "tac12_040	0.2	0.4	0\n" >> correct100.par
  printf "tac13_030	0.15	0.3	0\n" >> correct100.par
  printf "tac14_020	0.1	0.2	0\n" >> correct100.par
  printf "tac15_015	0.075	0.15	0\n" >> correct100.par
  printf "tac16_010	0.05	0.1	0\n" >> correct100.par
  printf "tac17_009	0.045	0.09	0\n" >> correct100.par
  printf "tac18_008	0.04	0.08	0\n" >> correct100.par
  printf "tac19_007	0.035	0.07	0\n" >> correct100.par
  printf "tac20_006	0.03	0.06	0\n" >> correct100.par
  printf "tac21_005	0.025	0.05	0\n" >> correct100.par
  printf "tac22_004	0.02	0.04	0\n" >> correct100.par
  printf "tac23_003	0.015	0.03	0\n" >> correct100.par
  printf "tac24_002	0.01	0.02	0\n" >> correct100.par
  printf "tac25_001	0.005	0.01	0\n" >> correct100.par
fi

if [ ! -f correct120.par ]; then
  printf "Parameters	R1	k2[1/min]	k2r[1/min]	R2	pRatio	WSS\n" > correct120.par
  printf "tac01-500	2.5	5.0	2	2.5	1	0\n" >> correct120.par
  printf "tac02-400	2.0	4.0	2	2.0	1	0\n" >> correct120.par
  printf "tac03-300	1.5	3.0	2	1.5	1	0\n" >> correct120.par
  printf "tac05-150	0.75	1.5	2	0.75	1	0\n" >> correct120.par
  printf "tac06-100	0.50	1.0	2	0.50	1	0\n" >> correct120.par
  printf "tac07-090	0.45	0.9	2	0.45	1	0\n" >> correct120.par
  printf "tac08-080	0.40	0.8	2	0.40	1	0\n" >> correct120.par
  printf "tac09-070	0.35	0.7	2	0.35	1	0\n" >> correct120.par
  printf "tac10-060	0.30	0.6	2	0.30	1	0\n" >> correct120.par
  printf "tac11-050	0.25	0.5	2	0.25	1	0\n" >> correct120.par
  printf "tac12-040	0.20	0.4	2	0.20	1	0\n" >> correct120.par
  printf "tac13-030	0.15	0.3	2	0.15	1	0\n" >> correct120.par
  printf "tac14-020	0.10	0.2	2	0.10	1	0\n" >> correct120.par
  printf "tac15-015	0.075	0.15	2	0.075	1	0\n" >> correct120.par
  printf "tac16-010	0.050	0.10	2	0.050	1	0\n" >> correct120.par
  printf "tac17-009	0.045	0.09	2	0.045	1	0\n" >> correct120.par
  printf "tac18-008	0.040	0.08	2	0.040	1	0\n" >> correct120.par
  printf "tac19-007	0.035	0.07	2	0.035	1	0\n" >> correct120.par
  printf "tac20-006	0.030	0.06	2	0.030	1	0\n" >> correct120.par
  printf "tac21-005	0.025	0.05	2	0.025	1	0\n" >> correct120.par
  printf "tac22-004	0.020	0.04	2	0.020	1	0\n" >> correct120.par
  printf "tac23-003	0.015	0.03	2	0.015	1	0\n" >> correct120.par
  printf "tac24-002	0.010	0.02	2	0.010	1	0\n" >> correct120.par
  printf "tac25-001	0.005	0.01	2	0.005	1	0\n" >> correct120.par
fi

if [ ! -f correct130.par ]; then
  printf "Parameters	R1	k2[1/min]	k2r[1/min]	R2	pRatio	WSS\n" > correct130.par
  printf "tac01-500	5	5	2	2.5	2	0\n" >> correct130.par
  printf "tac02-400	4	4	2	2.0	2	0\n" >> correct130.par
  printf "tac03-300	3	3	2	1.5	2	0\n" >> correct130.par
  printf "tac04-200	2	2	2	1.0	2	0\n" >> correct130.par
  printf "tac05-150	1.5	1.5	2	0.75	2	0\n" >> correct130.par
  printf "tac06-100	1.0	1.0	2	0.50	2	0\n" >> correct130.par
  printf "tac07-090	0.9	0.9	2	0.45	2	0\n" >> correct130.par
  printf "tac08-080	0.8	0.8	2	0.40	2	0\n" >> correct130.par
  printf "tac09-070	0.7	0.7	2	0.35	2	0\n" >> correct130.par
  printf "tac10-060	0.6	0.6	2	0.30	2	0\n" >> correct130.par
  printf "tac11-050	0.5	0.5	2	0.25	2	0\n" >> correct130.par
  printf "tac12-040	0.4	0.4	2	0.20	2	0\n" >> correct130.par
  printf "tac13-030	0.3	0.3	2	0.15	2	0\n" >> correct130.par
  printf "tac14-020	0.2	0.2	2	0.10	2	0\n" >> correct130.par
  printf "tac15-015	0.15	0.15	2	0.075	2	0\n" >> correct130.par
  printf "tac16-010	0.10	0.10	2	0.050	2	0\n" >> correct130.par
  printf "tac17-009	0.09	0.09	2	0.045	2	0\n" >> correct130.par
  printf "tac18-008	0.08	0.08	2	0.040	2	0\n" >> correct130.par
  printf "tac19-007	0.07	0.07	2	0.035	2	0\n" >> correct130.par
  printf "tac20-006	0.06	0.06	2	0.030	2	0\n" >> correct130.par
  printf "tac21-005	0.05	0.05	2	0.025	2	0\n" >> correct130.par
  printf "tac22-004	0.04	0.04	2	0.020	2	0\n" >> correct130.par
  printf "tac23-003	0.03	0.03	2	0.015	2	0\n" >> correct130.par
  printf "tac24-002	0.02	0.02	2	0.010	2	0\n" >> correct130.par
  printf "tac25-001	0.01	0.01	2	0.005	2	0\n" >> correct130.par
fi



if [ ! -f correct140.par ]; then
  printf "Parameters	R1	k2[1/min]	WSS\n" > correct140.par
  printf "tac01_500	0	5	0\n" >> correct140.par
  printf "tac02_400	0	4	0\n" >> correct140.par
  printf "tac03_300	0	3	0\n" >> correct140.par
  printf "tac04_200	0	2	0\n" >> correct140.par
  printf "tac05_150	0	1.5	0\n" >> correct140.par
  printf "tac06_100	0	1	0\n" >> correct140.par
  printf "tac07_090	0	0.9	0\n" >> correct140.par
  printf "tac08_080	0	0.8	0\n" >> correct140.par
  printf "tac09_070	0	0.7	0\n" >> correct140.par
  printf "tac10_060	0	0.6	0\n" >> correct140.par
  printf "tac11_050	0	0.5	0\n" >> correct140.par
  printf "tac12_040	0	0.4	0\n" >> correct140.par
  printf "tac13_030	0	0.3	0\n" >> correct140.par
  printf "tac14_020	0	0.2	0\n" >> correct140.par
  printf "tac15_015	0	0.15	0\n" >> correct140.par
  printf "tac16_010	0	0.1	0\n" >> correct140.par
  printf "tac17_009	0	0.09	0\n" >> correct140.par
  printf "tac18_008	0	0.08	0\n" >> correct140.par
  printf "tac19_007	0	0.07	0\n" >> correct140.par
  printf "tac20_006	0	0.06	0\n" >> correct140.par
  printf "tac21_005	0	0.05	0\n" >> correct140.par
  printf "tac22_004	0	0.04	0\n" >> correct140.par
  printf "tac23_003	0	0.03	0\n" >> correct140.par
  printf "tac24_002	0	0.02	0\n" >> correct140.par
  printf "tac25_001	0	0.01	0\n" >> correct140.par
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case 1: Noiseless frequently sampled data. \n"
printf " Test case 2: Save fitted TTACs. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output100.par output100.tac output100.svg

$PROGRAM -nnls -fit=output100.tac tissue1.tac tac04 output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 tissue1.tac output100.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-2 -abs=0.0001 correct100.par output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Save fitted TTACs. \n"
printf " Test case 3: Plot fitted TTACs. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output101.par output101.tac output101.svg

$PROGRAM -nnls -end=10 -fit=output101.tac -svg=output101.svg framed1.tac tac04 output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output101.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 framed1.tac output101.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-2 -abs=0.0001 -rel=1 correct100.par output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Same as 1.0.0 but applying BVLS. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output110.par output110.tac output110.svg

$PROGRAM -bvls -fit=output110.tac --silent tissue1.tac tac04 output110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 tissue1.tac output110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-2 -abs=0.0001 correct100.par output110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Same as 1.0.1 but applying BVLS. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output111.par output111.tac output111.svg

$PROGRAM -bvls -end=10 -fit=output111.tac -svg=output111.svg --silent framed1.tac tac04 output111.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output111.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 framed1.tac output111.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-2 -abs=0.0001 -rel=1 correct100.par output111.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Model R2 although data could be fitted with R1. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output120.par output120.tac output120.svg

$PROGRAM -model=R2 -fit=output120.tac -svg=output120.svg framed1.tac tac04 output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output120.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 framed1.tac output120.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-2 -abs=0.001 -rel=1 correct100.par output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-4 -abs=0.001 -rel=1 correct120.par output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=5 -abs=0.001 -rel=5 correct120.par output120.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case 1: Noiseless frequently sampled data. \n"
printf " Test case 2: Model R2 with data that requires R2. \n"
printf " Test case 3: Reference TAC in separate file. \n"
printf " Expected result: Correct results calculated, except for tac04 which is overdetermined. \n\n"

rm -f output130.par output130.tac output130.svg

$PROGRAM -model=R2 -fit=output130.tac tissue1.tac tissue2.tac output130.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacdel output130.tac rtac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 tissue1.tac output130.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-4 -abs=0.001 -rel=1 -tac=1,2,3,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25 correct130.par output130.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=5 -abs=0.001 -rel=5 correct130.par output130.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Model R2 with data that requires R2. \n"
printf " Test case 3: Reference TAC in separate file. \n"
printf " Expected result: Correct results calculated, except for tac04 which is overdetermined. \n\n"

rm -f output131.par output131.tac output131.svg

$PROGRAM -model=R2 -fit=output131.tac -svg=output131.svg framed1.tac framed2.tac output131.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output131.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacdel output131.tac rtac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=1 framed1.tac output131.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=1-4 -abs=0.001 -rel=1 -tac=1,2,3,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25 correct130.par output131.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -par=5 -abs=0.001 -rel=5 correct130.par output131.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"

printf "\n 1.4.0 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Using blood TAC as reference input. \n"
printf " Expected result: Correct k2 results calculated. \n\n"

rm -f output140.par output140.svg

$PROGRAM -nnls -svg=output140.svg framed1.tac inputf.tac output140.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output140.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=y -abs=0.0001 -rel=1 correct140.par output140.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.4.1 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Reference input is all zeroes. \n"
printf " Expected result: No error. \n\n"

taccalc inputf.tac - inputf.tac zero.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f output141.par

$PROGRAM framed1.tac zero.tac output141.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.4.2 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Reference region with very high K1 but k2 is zero. \n"
printf " Expected result: No error. \n\n"

rm -f output142.par

$PROGRAM framed1.tac posref1.tac output142.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.4.3 \n"
printf " Test case 1: Noiseless framed data. \n"
printf " Test case 2: Reference region with very low K1 and k2 is zero. \n"
printf " Expected result: No error. \n\n"

rm -f output143.par

$PROGRAM framed1.tac posref2.tac output143.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: Reference region does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM framed1.tac tac9999 output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "reference not found"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Reference that is part of all region names. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -svg=tmp.svg -d2 framed1.tac tac output.par 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "reference not found"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 3.0.0 \n"
printf " Test case 1: Real data. \n"
printf " Test case 2: Default model (R1). \n"
printf " Expected result: No error. \n\n"

$PROGRAM -nnls -end=1.67 -svg=tg2r33_r1.svg tg2r33.tac ctrl tg2r33_r1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f tg2r33_r1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
if [ ! -f tg2r33_r1.par ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case 1: Real data. \n"
printf " Test case 2: Model (R2). \n"
printf " Expected result: No error. \n\n"

$PROGRAM -model=R2 -svg=tg2r33_r2.svg tg2r33.tac ctrl tg2r33_r2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f tg2r33_r2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
if [ ! -f tg2r33_r2.par ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

