#!/bin/bash
#: Title      : test_tacsa
#: Date       : 2023-03-30
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacsa$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f water.fit ] || [ ! -f wblood.bld ]; then
rm -f wpet.tac wblood.tac
printf "FIT1        fit_sinf 0.6.19 (c) 2018 by Turku PET Centre\n" > water.fit
printf "Date:	2018-02-12 09:00:05\n" >> water.fit
printf "Data file:	lvcav.tac\n" >> water.fit
printf "Data unit:	g/mL\n" >> water.fit
printf "Time unit:	sec\n" >> water.fit
printf "Nr of VOIs:	1\n" >> water.fit
printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> water.fit
printf "BTAC	0	290	1336	0	8	0331	7.5	11.54	5.697	1.384E-003	38	0.081	4.24	10\n" >> water.fit
#printf "BTAC	0	290	1336	0	8	0331	7.856	11.54	5.697	1.384E-003	38	0.081	4.24	10\n" >> water.fit

fit2dat -c=0,360,1 water.fit wblood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f water.sif ]; then
rm -f wpet.tac wblood.tac
printf "28/03/2023 11:26:12  25 2 1 SIM1 O-15\n" > water.sif
printf "0 5\n" >> water.sif
printf "5 10\n" >> water.sif
printf "10 15\n" >> water.sif
printf "15 20\n" >> water.sif
printf "20 25\n" >> water.sif
printf "25 30\n" >> water.sif
printf "30 35\n" >> water.sif
printf "35 40\n" >> water.sif
printf "40 45\n" >> water.sif
printf "45 50\n" >> water.sif
printf "50 55\n" >> water.sif
printf "55 60\n" >> water.sif
printf "60 65\n" >> water.sif
printf "65 70\n" >> water.sif
printf "70 80\n" >> water.sif
printf "80 90\n" >> water.sif
printf "90 100\n" >> water.sif
printf "100 120\n" >> water.sif
printf "120 140\n" >> water.sif
printf "140 160\n" >> water.sif
printf "160 190\n" >> water.sif
printf "190 220\n" >> water.sif
printf "220 250\n" >> water.sif
printf "250 280\n" >> water.sif
printf "280 310\n" >> water.sif
fi


if [ ! -f water.par ] || [ ! -f wpet.tac ] || [ ! -f wblood.tac ] || [ ! -f wtissue.tac ]; then
printf "# model := SER3TCM\n" > water.par
printf "Parameters	K1[mL/(mL*min)]	K1/k2[mL/mL]	k3[1/min]	k3/k4	k5[1/min]	k5/k6	Vb[%%]	dT[sec]\n" >> water.par
printf "tac1	2.00	0.8	0	0	0	0	0	0\n" >> water.par
printf "tac2	1.00	0.8	0	0	0	0	0	0\n" >> water.par
printf "tac3	0.50	0.8	0	0	0	0	0	0\n" >> water.par
printf "tac4	0.10	0.8	0	0	0	0	0	0\n" >> water.par
printf "tac5	0.05	0.8	0	0	0	0	0	0\n" >> water.par

sim_3tcm water.par wblood.bld wblood.bld wtissue.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

# Add Vb
taccalc wblood.bld x 0.05 temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
taccalc wtissue.dat + temp.bld wpet.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

# Simulate PET frames
simframe wpet.dat water.sif wpet.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
simframe wblood.bld water.sif wblood.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
simframe wtissue.dat water.sif wtissue.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2svg water.svg -s wpet.tac -l wpet.dat -s wblood.tac -l wblood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f wcorr.par ]; then
printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	Vb[mL/mL]	WSS\n" > wcorr.par
printf "tac1	2.00	2.50	0.05	0\n" >> wcorr.par
printf "tac2	1.00	1.25	0.05	0\n" >> wcorr.par
printf "tac3	0.50	0.625	0.05	0\n" >> wcorr.par
printf "tac4	0.10	0.125	0.05	0\n" >> wcorr.par
printf "tac5	0.05	0.0625	0.05	0\n" >> wcorr.par
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Simulated radiowater data with frequent sampling. \n"
printf " Expected result: Close to correct results. \n\n"

rm -f sa100.tac bf100.tac t100.par
$PROGRAM -n=600 -bf=bf100.tac wblood.bld wblood.bld wpet.dat 3 t100.par sa100.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg bf100.svg -l bf100.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
for i in {1..5}; do hist2svg -c=$i sa100.tac 'sa100c'$i'.svg'; done;
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -rel=1 wcorr.par t100.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Simulated radiowater data with PET frames on tissue. \n"
printf " Expected result: Close to correct results. \n\n"

rm -f sa101.tac bf101.tac t101.par
$PROGRAM -n=600 -bf=bf101.tac wblood.bld wblood.bld wpet.tac 3 t101.par sa101.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg bf101.svg -l bf101.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
for i in {1..5}; do hist2svg -c=$i sa101.tac 'sa101c'$i'.svg'; done;
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -rel=1 wcorr.par t101.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Simulated radiowater data with PET frames on both blood and tissue. \n"
printf " Expected result: Not too far from correct. \n\n"

rm -f sa102.tac bf102.tac t102.par
$PROGRAM -n=600 -bf=bf102.tac wblood.tac wblood.tac wpet.tac 3 t102.par sa102.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg bf102.svg -l bf102.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
for i in {1..5}; do hist2svg -c=$i sa102.tac 'sa102c'$i'.svg'; done;
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -rel=10 -par=1 wcorr.par t102.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.1 -rel=20 -par=2 wcorr.par t102.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=30 -par=3 wcorr.par t102.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.3 \n"
printf " Test case: Data without Va. \n"
printf " Expected result: Close to correct results. \n\n"

rm -f sa103.tac bf103.tac t103.par

$PROGRAM -n=600 -bf=bf103.tac wblood.tac wblood.tac wtissue.tac 3 t103.par sa103.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg bf103.svg -l bf103.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
for i in {1..5}; do hist2svg -c=$i sa103.tac 'sa103c'$i'.svg'; done;
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -rel=5 -par=1 wcorr.par t103.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=10 -abs=0.05 -par=2 wcorr.par t103.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
