#!/bin/bash
#: Title      : test_yokoi
#: Date       : 2019-03-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../yokoi$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n verifying that required data exists \n"
if [ ! -f input.fit ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n make input TAC \n"
fit2dat -c=0,420,0.5 input.fit input.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacren --silent input.tac 1 blood_artery
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "\n simulate TTACs \n"

if [ ! -f simul1.par ]; then
  rm -f tissue1.tac framed1.tac
# Note that K1 unit is needed because not per sec as in input file
  printf "# model := SER3TCM\n" > simul1.par
  printf "Parameters,K1[mL/(min*mL)],K1/k2,k3,k4,k5,k6\n" >> simul1.par
  printf "tac01_500,5,1,0,0,0,0\n" >> simul1.par
  printf "tac02_400,4,1,0,0,0,0\n" >> simul1.par
  printf "tac03_300,3,1,0,0,0,0\n" >> simul1.par
  printf "tac04_200,2,1,0,0,0,0\n" >> simul1.par
  printf "tac05_150,1.5,1,0,0,0,0\n" >> simul1.par
  printf "tac06_100,1.0,1,0,0,0,0\n" >> simul1.par
  printf "tac07_090,0.9,1,0,0,0,0\n" >> simul1.par
  printf "tac08_080,0.8,1,0,0,0,0\n" >> simul1.par
  printf "tac09_070,0.7,1,0,0,0,0\n" >> simul1.par
  printf "tac10_060,0.6,1,0,0,0,0\n" >> simul1.par
  printf "tac11_050,0.5,1,0,0,0,0\n" >> simul1.par
  printf "tac12_040,0.4,1,0,0,0,0\n" >> simul1.par
  printf "tac13_030,0.3,1,0,0,0,0\n" >> simul1.par
  printf "tac14_020,0.2,1,0,0,0,0\n" >> simul1.par
  printf "tac15_015,0.15,1,0,0,0,0\n" >> simul1.par
  printf "tac16_010,0.10,1,0,0,0,0\n" >> simul1.par
  printf "tac17_009,0.09,1,0,0,0,0\n" >> simul1.par
  printf "tac18_008,0.08,1,0,0,0,0\n" >> simul1.par
  printf "tac19_007,0.07,1,0,0,0,0\n" >> simul1.par
  printf "tac20_006,0.06,1,0,0,0,0\n" >> simul1.par
  printf "tac21_005,0.05,1,0,0,0,0\n" >> simul1.par
  printf "tac22_004,0.04,1,0,0,0,0\n" >> simul1.par
  printf "tac23_003,0.03,1,0,0,0,0\n" >> simul1.par
  printf "tac24_002,0.02,1,0,0,0,0\n" >> simul1.par
  printf "tac25_001,0.01,1,0,0,0,0\n" >> simul1.par
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct100.par ]; then
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	K1/k2\n" > correct100.par
  printf "tac01_500	5	5	1\n" >> correct100.par
  printf "tac02_400	4	4	1\n" >> correct100.par
  printf "tac03_300	3	3	1\n" >> correct100.par
  printf "tac04_200	2	2	1\n" >> correct100.par
  printf "tac05_150	1.5	1.5	1\n" >> correct100.par
  printf "tac06_100	1	1	1\n" >> correct100.par
  printf "tac07_090	0.9	0.9	1\n" >> correct100.par
  printf "tac08_080	0.8	0.8	1\n" >> correct100.par
  printf "tac09_070	0.7	0.7	1\n" >> correct100.par
  printf "tac10_060	0.6	0.6	1\n" >> correct100.par
  printf "tac11_050	0.5	0.5	1\n" >> correct100.par
  printf "tac12_040	0.4	0.4	1\n" >> correct100.par
  printf "tac13_030	0.3	0.3	1\n" >> correct100.par
  printf "tac14_020	0.2	0.2	1\n" >> correct100.par
  printf "tac15_015	0.15	0.15	1\n" >> correct100.par
  printf "tac16_010	0.1	0.1	1\n" >> correct100.par
  printf "tac17_009	0.09	0.09	1\n" >> correct100.par
  printf "tac18_008	0.08	0.08	1\n" >> correct100.par
  printf "tac19_007	0.07	0.07	1\n" >> correct100.par
  printf "tac20_006	0.06	0.06	1\n" >> correct100.par
  printf "tac21_005	0.05	0.05	1\n" >> correct100.par
  printf "tac22_004	0.04	0.04	1\n" >> correct100.par
  printf "tac23_003	0.03	0.03	1\n" >> correct100.par
  printf "tac24_002	0.02	0.02	1\n" >> correct100.par
  printf "tac25_001	0.01	0.01	1\n" >> correct100.par
fi


if [ ! -f tissue1.tac ] || [ ! -f simul1.svg ]; then
  rm -f framed1.tac
  sim_3tcm simul1.par input.tac none tissue1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1.svg -l input.tac tissue1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f framed1.tac ] || [ ! -f simul1f.svg ]; then
  simframe tissue1.tac frames.dat framed1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul1f.svg -l input.tac framed1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f tissue2.tac ] || [ ! -f framed2.tac ] || [ ! -f simul2.par ]; then
# Note that K1 unit is needed because not per sec as in input file
  printf "# model := SER3TCM\n" > simul2.par
  printf "Parameters,K1[mL/(min*mL)],K1/k2,k3,k3/k4,k5,k5/k6,Vb\n" >> simul2.par
  printf "tac01,0.5,0.8,0,0,0,0,0.00\n" >> simul2.par
  printf "tac02,0.5,0.8,0,0,0,0,0.02\n" >> simul2.par
  printf "tac03,0.5,0.8,0,0,0,0,0.04\n" >> simul2.par
  printf "tac04,0.5,0.8,0,0,0,0,0.06\n" >> simul2.par

  sim_3tcm simul2.par input.tac none tissue2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe tissue2.tac frames.dat framed2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y simul2f.svg -l input.tac framed2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct200.par ]; then
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	K1/k2\n" > correct200.par
  printf "tac01	0.5	0.625	0.8\n" >> correct200.par
  printf "tac02	0.5	0.625	0.8\n" >> correct200.par
  printf "tac03	0.5	0.625	0.8\n" >> correct200.par
  printf "tac04	0.5	0.625	0.8\n" >> correct200.par
fi

if [ ! -f correct201.par ]; then
  printf "Parameters	K1[mL/(mL*min)]	SD	k2[1/min]	SD	K1/k2	SD\n" > correct201.par
  printf "tac01	0.5	0	0.625	0	0.8	0\n" >> correct201.par
  printf "tac02	0.5	0	0.625	0	0.8	0\n" >> correct201.par
  printf "tac03	0.5	0	0.625	0	0.8	0\n" >> correct201.par
  printf "tac04	0.5	0	0.625	0	0.8	0\n" >> correct201.par
fi

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Noiseless frequent data without blood volume. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output100.par output100.svg output100.tsv

$PROGRAM tissue1.tac input.tac 0.5 3 output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.00001 -rel=0.1 correct100.par output100.par 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Noiseless framed data without blood volume. \n"
printf " Test case 2: Plot data saved. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output101.par output101.svg output101.tsv

$PROGRAM -d1 -plot=output101.tsv framed1.tac input.tac 0.5 3 output101.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output101.tsv ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.001 -rel=5 correct100.par output101.par 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 \n"
printf " Test case 1: Noiseless framed data with blood volume. \n"
printf " Test case 2: SVG plot saved. \n"
printf " Expected result: Not too bad results calculated. \n\n"

rm -f output200.par output200.svg output200.tsv

$PROGRAM -d1 -svg=output200.svg -plot=output200.tsv framed2.tac input.tac 1 4 output200.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output200.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output200.tsv ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.05 -rel=15 correct200.par output200.par 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Noiseless framed data with blood volume. \n"
printf " Test case 2: Standard deviations saved. \n"
printf " Expected result: Results include SDs. \n\n"

rm -f output201.par

$PROGRAM -sd=yes framed2.tac input.tac 1 4 output201.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -sd=no -p=yes -abs=0.05 -rel=15 correct201.par output201.par 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -sd=yes -p=no -abs=0.01 correct201.par output201.par 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
