#!/bin/bash
#: Title      : test_paradd
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../paradd$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"


printf "\n make test data \n"

rm -f test1.csv
printf "parameters,K1,K1/k2,k3,k4\n" > test1.csv
printf "put_dx,1.0,2.0,3.0,4.0\n"  >> test1.csv
printf "cau_dx,2.0,3.0,4.0,5.0\n"  >> test1.csv
printf "put_sin,3.0,4.0,5.0,6.0\n" >> test1.csv
printf "cau_sin,4.0,5.0,6.0,7.0\n" >> test1.csv
printf "cereb,1.0,1.0,0.0,0.0\n" >> test1.csv

parformat -f=RES test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parformat -f=FIT test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parformat -f=IFT test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


rm -f correct1.csv
printf "parameters,K1/k2,k3\n" > correct1.csv
printf "put_dx,2.0,3.0\n"     >> correct1.csv
printf "put_sin,4.0,5.0\n"    >> correct1.csv
printf "cereb,1.0,0.0\n"      >> correct1.csv

rm -f correct2.csv
printf "parameters,K1/k2,k4\n" > correct2.csv
printf "cau_dx,3.0,5.0\n"     >> correct2.csv
printf "cau_sin,5.0,7.0\n"    >> correct2.csv
printf "cereb,1.0,0.0\n"      >> correct2.csv

rm -f test2a.csv
printf "parameters,R1,k2,BPnd\n" > test2a.csv
printf "put,1.0,0.1,1.0\n"      >> test2a.csv
printf "cau,1.0,0.2,2.0\n"      >> test2a.csv
printf "cer,1.0,0.3,0.0\n"      >> test2a.csv

rm -f test2b.csv
printf "parameters,R1,k2,BPnd\n" > test2b.csv
printf "put,1.0,0.1,2.0\n"      >> test2b.csv
printf "cau,1.0,0.2,3.0\n"      >> test2b.csv
printf "cer,1.0,0.3,0.0\n"      >> test2b.csv

rm -f test2c.csv
printf "parameters,R1,k2,BPnd\n" > test2c.csv
printf "put,1.0,0.1,3.0\n"      >> test2c.csv
printf "cau,1.0,0.2,4.0\n"      >> test2c.csv
printf "cer,1.0,0.3,0.0\n"      >> test2c.csv

rm -f correct3.csv
printf "parameters,BPnd,BPnd,BPnd\n" > correct3.csv
printf "put,1,2,3\n"                >> correct3.csv
printf "cau,2,3,4\n"                >> correct3.csv
printf "cer,0,0,0\n"                >> correct3.csv

if [ ! -f test4a.csv ] || [ ! -f test4b.csv ] || [ ! -f correct4.csv ]; then
  printf "parameters,SUV\n" > test4a.csv
  printf "put_dx,4.0\n"    >> test4a.csv
  printf "cau_dx,5.0\n"    >> test4a.csv
  printf "put_sin,6.0\n"   >> test4a.csv
  printf "cau_sin,7.0\n"   >> test4a.csv
  printf "cereb,2.0\n"     >> test4a.csv

  printf "parameters,SUVR\n" > test4b.csv
  printf "put_dx,2.0\n"     >> test4b.csv
  printf "cau_dx,2.5\n"     >> test4b.csv
  printf "put_sin,3.0\n"    >> test4b.csv
  printf "cau_sin,3.5\n"    >> test4b.csv

  printf "parameters,SUV,SUVR\n" > correct4.csv
  printf "put_dx,4.0,2.0\n"     >> correct4.csv
  printf "cau_dx,5.0,2.5\n"     >> correct4.csv
  printf "put_sin,6.0,3.0\n"    >> correct4.csv
  printf "cau_sin,7.0,3.5\n"    >> correct4.csv
  printf "cereb,2.0,\n"         >> correct4.csv
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dry mode. \n"
printf " Test case 2: Select TACs and parameters with names. \n"
printf " Expected result 1: no file edited or created. \n"
printf " Expected result 2: correct parameters and TACs selected. \n\n"

rm -f output.csv
$PROGRAM --dry -d3 -par=K1/k2,k3 -tac=sin output.csv test1.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.csv ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt selected_parameter "K1"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_parameter "K1/k2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_parameter "k3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_parameter "k4"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt selected_tac "put_dx"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "cau_dx"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "put_sin"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "cau_sin"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "cereb"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Dry mode. \n"
printf " Test case 2: Select TACs and parameters with numbers. \n"
printf " Expected result 1: no file edited or created. \n"
printf " Expected result 2: correct parameters and TACs selected. \n\n"

rm -f output.csv
$PROGRAM --dry -d3 -par=2-3 -tac=3-4 output.csv test1.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.csv ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt selected_parameter "K1"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_parameter "K1/k2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_parameter "k3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_parameter "k4"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt selected_tac "put_dx"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "cau_dx"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "put_sin"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "cau_sin"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt selected_tac "cereb"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Non-existing output file. \n"
printf " Test case 2: Select TACs and parameters with names. \n"
printf " Expected result: New file is made with correct contents. \n\n"

rm -f output.csv
$PROGRAM -par=K1/k2,k3 -tac=put,cereb output.csv test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.csv ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -sd=y -cl=y -tacnames=y -parnames=y -parunits=y correct1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: Overwrite existing output file using option -ovr. \n"
printf " Test case 2: Select TACs and parameters with names. \n"
printf " Expected result: New file is made with correct contents. \n\n"

$PROGRAM -ovr -par=K1/k2,k4 -tac=cau,cereb output.csv test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.csv ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -sd=y -cl=y -tacnames=y -parnames=y -parunits=y correct2.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Collect results of one parameter from 3 studies. \n"
printf " Test case 2: Matching parameter and TAC names in all files. \n"
printf " Expected result: New file is made with correct contents. \n\n"

rm -f output.csv
$PROGRAM --verbose -par=BPnd output.csv test2a.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM --verbose -par=BPnd output.csv test2b.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM --verbose -par=BPnd output.csv test2c.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -sd=y -cl=y -tacnames=y -parnames=y -parunits=y correct3.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Collect results of TACs that were fitted separately. \n"
printf " Expected result: New file is made with correct contents. \n\n"

rm -f output.csv temp1.csv temp2.csv temp3.csv
$PROGRAM -tac=put temp1.csv test2a.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -tac=cau temp2.csv test2a.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -tac=cer temp3.csv test2a.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM --verbose output.csv temp1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM --verbose -d4 output.csv temp2.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM --verbose -d4 output.csv temp3.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -p=y -sd=y -cl=y -tacnames=y -parnames=y -parunits=y test2a.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.0 \n"
printf " Test case: Parameter and TAC names overlap but do not match. \n"
printf " Expected result: Error. \n\n"

cp -f test1.csv output.csv

$PROGRAM output.csv test2a.csv 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "incompatible contents for adding."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.5.0 \n"
printf " Test case: Collect SUV and SUVR results of TACs, with reference missing from SUVR results. \n"
printf " Expected result: Combined file has correct contents. \n\n"

cp -f test4a.csv output.csv

$PROGRAM output.csv test4b.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct4.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

