#!/bin/bash
#: Title      : test_parai
#: Date       : 2019-02-27
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parai$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f P001_rat_cer_60_90_cc.res ] || [ ! -f correct.res ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi


printf "\n make test data \n"

if [ ! -f test1.csv ] || [ ! -f test1.res ] || [ ! -f test1.fit ] || [ ! -f test1.ift ]; then
  printf "parameters,K1,K1/k2,k3\n" > test1.csv
  printf "put_dx,0.5,0.9,0.025\n"   >> test1.csv
  printf "cau_dx,0.2,1.1,0\n"       >> test1.csv
  printf "put_sin,0.5,1.1,0.015\n"  >> test1.csv
  printf "cau_sin,0.3,0.9,0.01\n"   >> test1.csv
  printf "cereb,1.0,1.0,0.0\n"      >> test1.csv

  parformat -f=RES test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct1.csv ]; then
  printf "parameters,K1[%%],K1/k2[%%],k3[%%]\n" > correct1.csv
  printf "cau,-40,20,-200\n"                   >> correct1.csv
  printf "put,0,-20,50\n"                      >> correct1.csv
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: AI from test data. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: correct AIs calculated. \n\n"

rm -f output.csv

$PROGRAM test1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parsort output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch correct1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: AI from test data. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: correct AIs calculated. \n\n"

rm -f output.res

$PROGRAM test1.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch correct1.csv output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: AI from test data. \n"
printf " Test case 2: FIT format. \n"
printf " Expected result: correct AIs calculated. \n\n"

rm -f output.fit

$PROGRAM test1.fit output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n correct1.csv output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: AI from test data. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: correct AIs calculated. \n\n"

rm -f output.ift

$PROGRAM test1.ift output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch correct1.csv output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Old actual RES file. \n"
printf " Expected result: correct AIs calculated. \n\n"

rm -f output2.res

$PROGRAM P001_rat_cer_60_90_cc.res output2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch correct.res output2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

