#!/bin/bash
#: Title      : test_parformat
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parformat$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

PARMATCH=../../parmatch$EXT;
if [ ! -f $PARMATCH ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f patlak.csv ]; then
  printf "Parameters,Ki[mL/(mL*min)],Ic[mL/mL],r[unitless]\n" > patlak.csv
  printf "LN_1,0.025626,0.1161,0.9965\n" >> patlak.csv
  printf "LN_2,0.023099,0.1466,0.9991\n" >> patlak.csv
fi


printf "\n verifying that required data exists \n"

if [ ! -f mrglu.res ] || [ ! -f mrglu_csvint.csv ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f mrglu_wohdr.csv ] || [ ! -f mrglu_csvuk.csv ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f old.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 0.1.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption mrglu.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 0.2.0 \n"
printf " Test case: Extra argument when format is given. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -f=CSV-UK mrglu.res output.csv extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 0.2.1 \n"
printf " Test case: Extra argument when format is not given. \n"
printf " Expected result: Error. \n\n"

$PROGRAM mrglu.res extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n----------------------------------------------------------------\n"

printf "\n 0.3.0 \n"
printf " Test case: Optional settings are correct by default. \n"
printf " Expected result 1: Test print shows correct option setting. \n"
printf " Expected result 2: Output lists the correct file format. \n\n"

$PROGRAM  --debug mrglu.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt parfile1 "mrglu.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt new_format "unknown"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt save_header "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt format "RES"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 0.3.1 \n"
printf " Test case 1: Enter new format and file name. \n"
printf " Test case 2: Option to not save headers. \n"
printf " Expected result 1: Test print shows correct option setting. \n"
printf " Expected result 2: Output file is in intended file format. \n\n"

rm -f output.csv
$PROGRAM  --debug -f=CSV-INT -hdr=n mrglu.res output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt parfile1 "mrglu.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt parfile2 "output.csv"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt new_format "CSV-INT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt save_header "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.csv analysis_time
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.csv weighting
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt format "CSV-INT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 0.3.2 \n"
printf " Test case: Option to save headers. \n"
printf " Expected result 1: Test print shows correct option setting. \n"
printf " Expected result 2: Output file has headers. \n\n"

rm -f output.csv
$PROGRAM  --debug -f=CSV-INT -hdr=y mrglu.res output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt save_header "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.csv analysis_time "2005-09-20"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.csv weighting "no"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n----------------------------------------------------------------\n"

printf "\n 0.9.0 \n"
printf " Test case: Input file not given. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -f=CSV-UK 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.9.1 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.res)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -f=CSV-UK nonexistingfile.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.res)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Basic tests \n"
printf "===================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: CSV-INT to CSV-UK with headers\n"
printf " Expected result 1: parmatch reports matching data. \n"
printf " Expected result 2: formats are correctly identified. \n\n"

$PROGRAM mrglu_csvint.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-INT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.csv
$PROGRAM -f=CSV-UK -hdr=y mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftmatch mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: CSV-INT to CSV-UK without headers\n"
printf " Expected result: parmatch reports matching data. \n"

rm -f output.csv
$PROGRAM -f=CSV-UK -hdr=n mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftmatch mrglu_csvint.csv output.csv
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: CSV-INT to TSV-UK with headers\n"
printf " Expected result 1: parmatch reports matching data. \n"
printf " Expected result 2: formats are correctly identified. \n\n"

$PROGRAM mrglu_csvint.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-INT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.csv
$PROGRAM -f=TSV-UK -hdr=y mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "TSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftmatch mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: CSV-INT to TSV-UK without headers\n"
printf " Expected result: parmatch reports matching data. \n"

rm -f output.csv
$PROGRAM -f=TSV-UK -hdr=n mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "TSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvint.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftmatch mrglu_csvint.csv output.csv
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: CSV-UK to TSV-INT with headers\n"
printf " Expected result 1: parmatch reports matching data. \n"
printf " Expected result 2: formats are correctly identified. \n\n"

$PROGRAM mrglu_csvuk.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.csv
$PROGRAM -f=TSV-INT -hdr=y mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "TSV-INT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftmatch mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: CSV-UK to TSV-INT without headers\n"
printf " Expected result: parmatch reports matching data. \n"

rm -f output.csv
$PROGRAM -f=TSV-INT -hdr=n mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "TSV-INT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftmatch mrglu_csvuk.csv output.csv
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n 1.3.0 \n"
printf " Test case: CSV-UK to XML.\n"
printf " Expected result: file can be created. \n"

rm -f output.xml
$PROGRAM -f=XML -hdr=n mrglu_csvuk.csv output.xml
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.xml ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 1.4.0 \n"
printf " Test case: Plain CSV-UK to CSV-UK without units.\n"
printf " Expected result: file saved without units. \n"

rm -f output.csv
$PROGRAM -f=CSV-UK -units=n patlak.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PARMATCH -parunits=n -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 patlak.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PARMATCH -parunits=y patlak.csv output.csv
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.4.1 \n"
printf " Test case: Plain CSV-UK to CSV-UK with units.\n"
printf " Expected result: file saved with units. \n"

rm -f output.csv
$PROGRAM -f=CSV-UK -units=y patlak.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 patlak.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Old result format \n"
printf "===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: RES to CSV-UK with headers\n"
printf " Test case 2: Back to RES format\n"
printf " Expected result 1: parmatch reports matching data. \n"
printf " Expected result 2: formats are correctly identified. \n\n"

$PROGRAM mrglu.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "RES"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.csv
$PROGRAM -f=CSV-UK -hdr=y mrglu.res output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu.res output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch mrglu_csvuk.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.res
$PROGRAM -f=RES output.csv output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "RES"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 mrglu.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Old fit format \n"
printf "===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case 1: FIT to CSV-UK with headers\n"
printf " Test case 2: Back to FIT format\n"
printf " Expected result 1: parmatch reports matching data. \n"
printf " Expected result 2: formats are correctly identified. \n\n"

$PROGRAM old.fit 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "FIT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.csv
$PROGRAM -f=CSV-UK -hdr=y old.fit output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.csv 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "CSV-UK"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PARMATCH -parunits=n -tacnames=y -sd=n -cl=n -wss=y -abs=1E-6 -rel=0.1 old.fit output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit
$PROGRAM -f=FIT output.csv output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM output.fit 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format "FIT"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


$PARMATCH -parunits=y -tacnames=y -sd=y -cl=y -wss=y -abs=1E-6 -rel=0.1 old.fit output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftmatch old.fit output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

