#!/bin/bash
#: Title      : test_parrenp
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parrenp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


printf "\n make test data \n"

if [ ! -f test1.csv ] || [ ! -f test1.res ] || [ ! -f test1.fit ] || [ ! -f test1.ift ]; then
  printf "parameters,K1,K1/k2,k3,k4\n" > test1.csv
  printf "put_dx,1.0,2.0,3.0,4.0\n"   >> test1.csv
  printf "cau_dx,2.0,3.0,4.0,5.0\n"   >> test1.csv
  printf "put_sin,3.0,4.0,5.0,6.0\n"  >> test1.csv
  printf "cau_sin,4.0,5.0,6.0,7.0\n"  >> test1.csv
  printf "cereb,1.0,1.0,0.0,0.0\n"    >> test1.csv

  parformat -f=RES test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.csv ]; then
  printf "parameters,R1,SD,k2,BPnd,95%%CL1,95%%CL2\n" > test2.csv
  printf "put,1.0,0.05,0.1,1.0,0.9,1.1\n"    >> test2.csv
  printf "cau,1.0,0.04,0.2,2.0,1.9,2.1\n"    >> test2.csv
  printf "cer,1.0,0.03,0.3,0.0,-0.1,0.1\n"   >> test2.csv
fi

if [ ! -f test3.csv ]; then
  printf "parameters,AIC,AIC,AIC,AIC,AIC,AIC\n" > test3.csv
  printf "study1,1.0,0.05,0.1,1.0,0.9,1.1\n"    >> test3.csv
  printf "study2,1.0,0.04,0.2,2.0,1.9,2.1\n"    >> test3.csv
  printf "study3,1.0,0.03,0.3,0.0,-0.1,0.1\n"   >> test3.csv
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: List current parameter names. \n"
printf " Expected result: correct parameter names printed. \n\n"

OUTPUT="$($PROGRAM test1.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
TESTSTR="$(printf "K1\nK1/k2\nk3\nk4\n" | tr -d '\n\r')"
printf "%s\n" "${TESTSTR}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: List current parameter names in dry mode. \n"
printf " Expected result: correct parameter names printed. \n\n"

OUTPUT="$($PROGRAM -dry test1.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
TESTSTR="$(printf "K1\nK1/k2\nk3\nk4\n" | tr -d '\n\r')"
printf "%s\n" "${TESTSTR}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: List current parameter names. \n"
printf " Test case 2: File contains SD and CLs. \n"
printf " Expected result: correct parameter names printed. \n\n"

OUTPUT="$($PROGRAM test2.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
TESTSTR="$(printf "R1\nk2\nBPnd\n" | tr -d '\n\r')"
printf "%s\n" "${TESTSTR}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 \n"
printf " Test case 1: Select parameter with name. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: correct parameter correctly renamed. \n\n"

cp -f test1.csv output.csv

$PROGRAM output.csv K1/k2 pc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "K1\npc\nk3\nk4\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Select parameter with name. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: correct parameter correctly renamed. \n\n"

cp -f test1.ift output.ift

$PROGRAM output.ift K1/k2 pc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "K1\npc\nk3\nk4\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.ift | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case 1: Select parameter with name. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: correct parameter correctly renamed. \n\n"

cp -f test1.res output.res

$PROGRAM output.res K1/k2 pc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "K1\npc\nk3\nk4\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.res | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case 1: Select parameter with number. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: correct parameter correctly renamed. \n\n"

cp -f test1.csv output.csv

$PROGRAM output.csv 2 pc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "K1\npc\nk3\nk4\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case 1: Select parameter with number. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: correct parameter correctly renamed. \n\n"

cp -f test1.ift output.ift

$PROGRAM output.ift 2 pc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "K1\npc\nk3\nk4\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.ift | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.2 \n"
printf " Test case 1: Select parameter with number. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: correct parameter correctly renamed. \n\n"

cp -f test1.res output.res

$PROGRAM output.res 2 pc
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "K1\npc\nk3\nk4\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.res | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.2.0 \n"
printf " Test case 1: Dry mode. \n"
printf " Expected result 1: file not changed. \n"
printf " Expected result 2: correct stdout. \n\n"

cp -f test1.csv output.csv

$PROGRAM -dry output.csv K1/k2 pc 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
OUTPUT="$(< stdout.txt)"

parmatch test1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

if [ ! "${OUTPUT}" = "K1/k2 -> pc" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.0.0 \n"
printf " Test case: Collection file with same parameter names. \n"
printf " Expected result: only first parameter renamed. \n\n"

cp -f test3.csv output.csv

$PROGRAM output.csv AIC model1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "model1\nAIC\nAIC\nAIC\nAIC\nAIC\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case 1: Collection file with same parameter names. \n"
printf " Test case 2: Parameters can be renamed one by one. \n"
printf " Expected result: correct parameter names. \n\n"

$PROGRAM output.csv AIC model2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.csv AIC model3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.csv AIC model4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.csv AIC model5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.csv AIC model6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

TESTSTR="$(printf "model1\nmodel2\nmodel3\nmodel4\nmodel5\nmodel6\n" | tr -d '\n\r')"
OUTPUT="$($PROGRAM output.csv | tr -d '\n\r')"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "%s\n" "${OUTPUT}"
if [ ! "${OUTPUT}" = "${TESTSTR}" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

