#!/bin/bash
#: Title      : test_parsort
#: Date       : 2019-09-05
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parsort$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


printf "\n make test data \n"

rm -f test1.csv correct1.csv

printf "parameters,p1,p2\n" > test1.csv
printf "put_dx,1.0,2.0\n"  >> test1.csv
printf "cau_dx,2.0,3.0\n"  >> test1.csv
printf "put_sin,3.0,4.0\n" >> test1.csv
printf "cau_sin,4.0,5.0\n" >> test1.csv

printf "parameters,p1,p2\n" > correct1.csv
printf "cau_dx,2.0,3.0\n"  >> correct1.csv
printf "cau_sin,4.0,5.0\n" >> correct1.csv
printf "put_dx,1.0,2.0\n"  >> correct1.csv
printf "put_sin,3.0,4.0\n" >> correct1.csv

parformat -f=RES test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parformat -f=FIT test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parformat -f=IFT test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Sort by TAC name results in CSV, RES, and FIT format. \n"
printf " Expected result: parameters are saved in sorted order. \n\n"

$PROGRAM test1.csv test1.res test1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=y -parnames=y -abs=0.0001 correct1.csv test1.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=y -parnames=y -abs=0.0001 correct1.csv test1.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=y -parnames=n -abs=0.0001 correct1.csv test1.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

