#!/bin/bash
#: Title      : test_sifisot
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../sifisot$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f ub0371dy2.img.sif ] || [ ! -f ub0371dy3.img.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Set isotope to SIFs which do not have isotope. \n"
printf " Expected result: Correct SIFs saved. \n"

cp -f ub0371dy2.img.sif file2.sif
cp -f ub0371dy3.img.sif file3.sif

$PROGRAM file?.sif C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift file2.sif > file2.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift file3.sif > file3.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval file2.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file3.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Try to change isotope again. \n"
printf " Expected result: Warning and files not changed. \n"

$PROGRAM file?.sif F-18 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift file2.sif > file2.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift file3.sif > file3.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval file2.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file3.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt Warning
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Try to set the same isotope again. \n"
printf " Expected result: Notice and files not changed. \n"

$PROGRAM file?.sif C-11 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift file2.sif > file2.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift file3.sif > file3.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval file2.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file3.ift isotope C-11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt Note
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Try to change isotope again with force option. \n"
printf " Expected result: Correct SIFs saved. \n"

$PROGRAM --force file?.sif F-18 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift file2.sif > file2.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift file3.sif > file3.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval file2.ift isotope F-18
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval file3.ift isotope F-18
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: List isotopes from all SIFs. \n"
printf " Expected result: No errors. \n"

$PROGRAM *.sif 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
