#!/bin/bash
#: Title      : test_flat2nii
#: Date       : 2023-08-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../flat2nii$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f flat1.txt ] || [ ! -f flat1.bin ]; then
  printf "\n creating flat1.txt \n"
  printf "frame 1 plane 1\n"
  printf "0 0 0 0 0\n" >  flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "frame 1 plane 2\n"
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "frame 1 plane 3\n"
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "0 0 0 0 0\n" >> flat1.txt
  printf "frame 2 plane 1\n"
  printf "1 0 0 0 0\n" >> flat1.txt
  printf "0 1 0 0 0\n" >> flat1.txt
  printf "0 0 1 0 0\n" >> flat1.txt
  printf "0 0 0 1 0\n" >> flat1.txt
  printf "0 0 0 0 1\n" >> flat1.txt
  printf "0 0 0 0 1\n" >> flat1.txt
  printf "frame 2 plane 2\n"
  printf "2 2 0 0 0\n" >> flat1.txt
  printf "2 2 2 0 0\n" >> flat1.txt
  printf "0 2 2 2 0\n" >> flat1.txt
  printf "0 0 2 2 2\n" >> flat1.txt
  printf "0 0 0 2 2\n" >> flat1.txt
  printf "0 0 0 0 2\n" >> flat1.txt
  printf "frame 2 plane 3\n"
  printf "3 3 0 0 0\n" >> flat1.txt
  printf "3 3 3 0 0\n" >> flat1.txt
  printf "0 3 3 3 0\n" >> flat1.txt
  printf "0 0 3 3 3\n" >> flat1.txt
  printf "0 0 0 3 3\n" >> flat1.txt
  printf "0 0 0 0 3\n" >> flat1.txt

  printf "\n creating flat1.bin \n"
  asc2flat flat1.txt flat1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Make image from flat file. \n"
printf " Expected result: Correct image created. \n\n"

rm -f output.nii

$PROGRAM flat1.bin 5 6 3 2 output
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -s output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2flat --silent output.nii output.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
diff flat1.bin output.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"

nii_lhdr output.nii > header.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval header.txt pixdim "1 1 1 1 0 0 0 0"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n\n 1.0.1 \n"
printf " Test case: Same but set pixel size and overwrite existing image. \n"
printf " Expected result: Correct image created. \n\n"

$PROGRAM -pxlsize=2.2,2.3,2.5 flat1.bin 5 6 3 2 output
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

nii_lhdr output.nii > header.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval header.txt pixdim "1 2.2 2.3 2.5 0 0 0 0"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n\n 2.0.0 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM flat1.bin 5 6 3 2 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM flat1.bin 5 6 3 output 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid dimension."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n\n 2.1.0 \n"
printf " Test case: Mismatching matrix size. \n"
printf " Expected result: Error. \n\n"

$PROGRAM flat1.bin 5 6 3 3 output 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "binary file does not contain data for all pixels."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM flat1.bin 5 6 3 1 output 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "mismatching matrix size and binary data."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

