#!/bin/bash
#: Title      : test_sim_av
#: Date       : 2019-01-24
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../sim_av$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f bolus.dat ] || [ ! -f stead100.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f subj1_ab.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f input.bld ]; then
  fit2dat -a=30 subj1_ab.fit input.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Only PAR filename given as argument. \n"
printf " Expected result: Correct file saved. \n\n"

rm -f output.par
$PROGRAM output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat output.par 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt format TSV-UK
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "\n 1.1.0 \n"
printf " Test case 1: BTAC from actual study. \n"
printf " Test case 2: Parameters from template file. \n"
printf " Expected result: Reasonable venous TAC calculated. \n\n"

$PROGRAM output.par input.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 1.1.0" test110.svg -l input.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taccalc output.bld div input.bld ratio.bld
tac2svg -mt="Test 1.1.0 vena per artery" test110b.svg -l ratio.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Validity in perfect steady-state without vascular volume \n"
printf "===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: Steady-state and 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 equals Flow. \n"
printf " Expected result 1: Venous concentration reaches arterial level. \n"
printf " Expected result 2: Tissue concentration reaches correct level. \n\n"

rm -f test1.par
printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test1.par
printf "btac1	0.6	0.6	0.3	0	0\n" >> test1.par

rm -f output.bld temp.dat temp.ift output.tac

tacformat -f=PMOD stead100.dat data.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xset=s -yset=kBq/mL data.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d3 -ttac=output.tac test1.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.0.0" test200.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taccut output.tac 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 30
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case 1: Steady-state and 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 half of Flow. \n"
printf " Expected result 1: Venous concentration reaches arterial level. \n"
printf " Expected result 2: Tissue concentration reaches correct level. \n\n"

rm -f test2.par
printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test2.par
printf "btac1	2.0	1.0	1.5	0	0\n" >> test2.par

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -ttac=output.tac test2.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.0.1" test201.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taccut output.tac 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.1 temp.ift value[1][1] 150
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "\n 2.1.0 \n"
printf " Test case 1: Steady-state and irreversible 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 one tenth of Flow. \n"
printf " Expected result 1: Tissue concentration increases steadily. \n"
printf " Expected result 2: Venous concentration stays below arterial level. \n\n"

printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test3.par
printf "btac1	1.0	0.1	0	0	0\n" >> test3.par

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -d3 -ttac=output.tac test3.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.1.0" test210.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case 1: Steady-state and irreversible 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 one half of Flow. \n"
printf " Expected result 1: Tissue concentration increases steadily. \n"
printf " Expected result 2: Venous concentration stays below arterial level. \n\n"

printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test4.par
printf "btac1	0.2	0.1	0	0	0\n" >> test4.par

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -d3 -ttac=output.tac test4.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.1.1" test211.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 50
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.2 \n"
printf " Test case 1: Steady-state and irreversible 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 equals Flow. \n"
printf " Expected result 1: Tissue concentration increases steadily. \n"
printf " Expected result 2: Venous concentration stays at zero. \n\n"

printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test5.par
printf "btac1	0.1	0.1	0	0	0\n" >> test5.par

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -d3 -ttac=output.tac test5.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.1.2" test212.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.3 \n"
printf " Test case 1: Steady-state and irreversible 3TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 one half of Flow. \n"
printf " Expected result 1: Tissue concentration increases steadily. \n"
printf " Expected result 2: Venous concentration reaches certain level. \n\n"

printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4	k5[1/min]	k5/k6\n" > test6.par
printf "btac1	2.0	1.0	0.5	0.5	0.5	0.1	0\n" >> test6.par
# Ki=0.022222...

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -d3 -ttac=output.tac test6.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.1.3" test213.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 98.8888889
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "\n 2.2.0 \n"
printf " Test case 1: Bolus and 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 half of Flow. \n"
printf " Expected result 1: Venous AUC is correct. \n"
printf " Expected result 2: Tissue AUC is correct. \n\n"

rm -f test10.par
printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test10.par
printf "btac1	2.0	1.0	1.0	0	0\n" >> test10.par

tacformat -f=PMOD bolus.dat data.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xset=s -yset=kBq/mL data.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i data.bld abauc.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -ttac=output.tac test10.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -x2=100 -mt="Test 2.2.0" test220.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

interpol -i output.bld vbauc.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i output.tac tauc.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.2.0 AUC" test220b.svg -l abauc.bld vbauc.bld tauc.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut vbauc.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 1000
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taccut tauc.tac 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 1000
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.1 \n"
printf " Test case 1: Bolus and irreversible 1TCM. \n"
printf " Test case 2: Simulate TTAC saved. \n"
printf " Test case 3: K1 half of Flow. \n"
printf " Expected result 1: Venous AUC is correct. \n"
printf " Expected result 2: Tissue AUC is correct. \n\n"

printf "Parameters	f[mL/(mL*min)]	K1[mL/(mL*min)]	K1/k2	k3[1/min]	k3/k4\n" > test11.par
printf "btac1	2.0	0.1	0.0	0	0\n" >> test11.par

rm -f output.bld temp.dat temp.ift output.tac

$PROGRAM -ttac=output.tac test11.par data.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -x2=100 -mt="Test 2.2.1" test221.svg -l data.bld output.bld output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taccut output.tac 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 temp.ift value[1][1] 1.666666667
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taccalc data.bld x 0.95 test.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 test.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

interpol -i output.bld vbauc.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Test 2.2.1 AUC" test221b.svg -l data.bld abauc.bld vbauc.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccut vbauc.bld 999.9 1000.1 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift temp.dat > temp.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.01 temp.ift value[1][1] 950
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

