#!/bin/bash
#: Title      : test_sim_o2
#: Date       : 2023-02-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../sim_o2$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f o2.fit ] || [ ! -f water.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f o2metab.ift ]; then
  printf "k1 := 1.307e-03\n"     > o2metab.ift
  printf "k1+k3 := 3.341e-03\n" >> o2metab.ift
fi

if [ ! -f blood.tac ] || [ ! -f blood_o.tac ] || [ ! -f blood_w.tac ]; then
  printf "\n calculate input data from o2 study for simulations \n"
  fit2dat -c=0,420,1 o2.fit blood.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  o2metab blood.tac o2metab.ift blood_o.tac blood_w.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tac2svg -legend=y o2blood.svg -l blood.tac blood_o.tac blood_w.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


if [ ! -f water.tac ]; then
  printf "\n calculate input data from radiowater study for simulations \n"
  fit2dat -c=0,420,1 water.fit temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tacadd -ovr water.tac temp.tac LV
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

