#!/bin/bash
#: Title      : test_simttm
#: Date       : 2020-01-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simttm$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f erlangpdf.fit ] || [ ! -f erlangpdf.tac ] || [ ! -f erlangpdf.svg ]; then
  printf "\n Simulating Erlang PDF curves with AUC of 100 \n"

  printf "FIT1        tpcclib 0.7.5 (c) 2020 by Turku PET Centre\n"  > erlangpdf.fit
  printf "Date:	2020-01-26 20:03:15\n" >> erlangpdf.fit
  printf "Data file:	dummy.tac\n" >> erlangpdf.fit
  printf "Data unit:	g/mL\n" >> erlangpdf.fit
  printf "Time unit:	sec\n" >> erlangpdf.fit
  printf "Nr of VOIs:	11\n" >> erlangpdf.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> erlangpdf.fit
  printf "Erlang pdf N=2	0	180	100	0	3	1441	100.0	0.15	2\n" >> erlangpdf.fit
  printf "Erlang pdf N=3	0	180	100	0	3	1441	100.0	0.15	3\n" >> erlangpdf.fit
  printf "Erlang pdf N=4	0	180	100	0	3	1441	100.0	0.15	4\n" >> erlangpdf.fit
  printf "Erlang pdf N=5	0	180	100	0	3	1441	100.0	0.15	5\n" >> erlangpdf.fit
  printf "Erlang pdf N=6	0	180	100	0	3	1441	100.0	0.15	6\n" >> erlangpdf.fit
  printf "Erlang pdf N=7	0	180	100	0	3	1441	100.0	0.15	7\n" >> erlangpdf.fit
  printf "Erlang pdf N=8	0	180	100	0	3	1441	100.0	0.15	8\n" >> erlangpdf.fit
  printf "Erlang pdf N=9	0	180	100	0	3	1441	100.0	0.15	9\n" >> erlangpdf.fit
  printf "Erlang pdf N=10	0	180	100	0	3	1441	100.0	0.15	10\n" >> erlangpdf.fit
  printf "Erlang pdf N=11	0	180	100	0	3	1441	100.0	0.15	11\n" >> erlangpdf.fit
  printf "Erlang pdf N=12	0	180	100	0	3	1441	100.0	0.15	12\n" >> erlangpdf.fit

  fit2dat -c=0,180,0.2 erlangpdf.fit erlangpdf.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tac2svg -legend=y -mt="Erlang PDFs" erlangpdf.svg -l erlangpdf.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi



if [ ! -f fdg_ap.bld ] || [ ! -f correct_fdg_pv.bld ]; then
  printf "\n Creating FDG PTACs based on figure in publication by Winterdahl et al., 2011 \n"
  printf "time[sec]\tCa\n"   > fdg_ap.bld
  printf "5\t0\n"     >> fdg_ap.bld
  printf "10\t0\n"    >> fdg_ap.bld
  printf "15\t2\n"    >> fdg_ap.bld
  printf "20\t52\n"   >> fdg_ap.bld
  printf "25\t100\n"  >> fdg_ap.bld
  printf "31\t137\n"  >> fdg_ap.bld
  printf "36\t300\n"  >> fdg_ap.bld
  printf "41\t282\n"  >> fdg_ap.bld
  printf "46\t114\n"  >> fdg_ap.bld
  printf "51\t55\n"   >> fdg_ap.bld
  printf "56\t50\n"   >> fdg_ap.bld
  printf "61\t52\n"   >> fdg_ap.bld
  printf "65\t52\n"   >> fdg_ap.bld
  printf "71\t52\n"   >> fdg_ap.bld
  printf "76\t52\n"   >> fdg_ap.bld
  printf "81\t52\n"   >> fdg_ap.bld
  printf "86\t51\n"   >> fdg_ap.bld
  printf "91\t50\n"   >> fdg_ap.bld
  printf "101\t48\n"  >> fdg_ap.bld
  printf "111\t46\n"  >> fdg_ap.bld
  printf "121\t43\n"  >> fdg_ap.bld
  printf "151\t38\n"  >> fdg_ap.bld
  printf "# studynr := test1\n"  >> fdg_ap.bld

  printf "time[sec]\tCpv\n"   > correct_fdg_pv.bld
  printf "5\t0\n"     >> correct_fdg_pv.bld
  printf "10\t0\n"    >> correct_fdg_pv.bld
  printf "15\t0\n"    >> correct_fdg_pv.bld
  printf "20\t3\n"    >> correct_fdg_pv.bld
  printf "25\t10\n"   >> correct_fdg_pv.bld
  printf "31\t25\n"   >> correct_fdg_pv.bld
  printf "36\t45\n"   >> correct_fdg_pv.bld
  printf "41\t80\n"   >> correct_fdg_pv.bld
  printf "46\t92\n"   >> correct_fdg_pv.bld
  printf "51\t80\n"   >> correct_fdg_pv.bld
  printf "56\t75\n"   >> correct_fdg_pv.bld
  printf "61\t72\n"   >> correct_fdg_pv.bld
  printf "65\t64\n"   >> correct_fdg_pv.bld
  printf "71\t59\n"   >> correct_fdg_pv.bld
  printf "76\t55\n"   >> correct_fdg_pv.bld
  printf "81\t53\n"   >> correct_fdg_pv.bld
  printf "86\t51\n"   >> correct_fdg_pv.bld
  printf "91\t50\n"   >> correct_fdg_pv.bld
  printf "101\t48\n"  >> correct_fdg_pv.bld
  printf "111\t46\n"  >> correct_fdg_pv.bld
  printf "121\t43\n"  >> correct_fdg_pv.bld
  printf "151\t38\n"  >> correct_fdg_pv.bld
  printf "# studynr := test1\n"  >> correct_fdg_pv.bld
fi






printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Erlang PDF N=2 as input. \n"
printf " Test case 2: One- to ten-compartmental TTM. \n"
printf " Expected result: output similar to Erlang PDF with relevant N. \n\n"

tacadd -ovr input.tac erlangpdf.tac 1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf " 1-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 2
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 1 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 2-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 2 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 3-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 3 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 4-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 5
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 4 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 5-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 6
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 5 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 6-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 7
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 6 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 7-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 7 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 8-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 9
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 8 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 9-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 10
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 9 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf " 10-compartmental TTM \n"
tacadd -ovr --silent correct.tac erlangpdf.tac 11
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM input.tac 10 0.15 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.02 -abs=0.001 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0


printf "\n ========================================================================\n"
printf "\n 2.0.0 - Portal vein simulation \n"
printf " Test case: FDG. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output.bld output200.svg

$PROGRAM fdg_ap.bld 1 0.033 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="FDG portal vein" output200.svg fdg_ap.bld -s correct_fdg_pv.bld -l output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=13 -rel=1 correct_fdg_pv.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
