#!/bin/bash
#: Title      : test_fit_1tcm
#: Date       : 2020-03-01
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_1tcm$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f carfentanil_apc.fit ] || [ ! -f carfentanil_parentfract.fit ]; then
  rm -f carfentanil_apc.bld carfentanil_ab.bld
  printf "FIT1        fit_sinf 0.6.15 (c) 2017 by Turku PET Centre\n" > carfentanil_apc.fit
  printf "Date:	2017-06-01 09:47:53\n" >> carfentanil_apc.fit
  printf "Data file:	unchanged.kbq\n" >> carfentanil_apc.fit
  printf "Data unit:	kBq/mL\n" >> carfentanil_apc.fit
  printf "Time unit:	min\n" >> carfentanil_apc.fit
  printf "Nr of VOIs:	1\n" >> carfentanil_apc.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> carfentanil_apc.fit
  printf "Plasma parent .	0.010	68.411	106	1.77E+002	12	0331	0.75	3.880988E-001	5.052719E-001	1.698325E-002	2.123866E+000	1.071961E-001	1.794217E+001	4.367584E-001	9.759633E+001	3.843467E+000	1.278706E+000	3.857623E-006\n" >> carfentanil_apc.fit

  printf "FIT1        fit_ppf 0.6.13 (c) 2017 by Turku PET Centre\n" > carfentanil_parentfract.fit
  printf "Date:	2017-03-22 10:30:49\n" >> carfentanil_parentfract.fit
  printf "Data file:	unchanged.rat\n" >> carfentanil_parentfract.fit
  printf "Data unit:	unitless\n" >> carfentanil_parentfract.fit
  printf "Time unit:	min\n" >> carfentanil_parentfract.fit
  printf "Nr of VOIs:	1\n" >> carfentanil_parentfract.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> carfentanil_parentfract.fit
  printf "Parent . .	5.000	48.000	8	1.84E-003	5	0846	3.827078E-001	1.459124E+000	1.304178E+002	1.000000E+000	2.632742E+000\n" >> carfentanil_parentfract.fit
fi

if [ ! -f carfentanil_apc.bld ] || [ ! -f carfentanil_ab.bld ]; then
  printf "\n calculate input data for simulations \n"
  fit2dat -c=0,80,0.1 carfentanil_apc.fit carfentanil_apc.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  fit2dat -c=0,80,0.1 carfentanil_parentfract.fit carfentanil_parentfract.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  taccalc carfentanil_apc.bld div carfentanil_parentfract.bld carfentanil_ap.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tacunit -yset=kBq/mL carfentanil_ap.bld
  tacren carfentanil_ap.bld 1 Plasma total
  taccalc carfentanil_ap.bld - carfentanil_apc.bld carfentanil_apm.bld
  tacren carfentanil_apm.bld 1 Plasma metabolite
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  p2blood carfentanil carfentanil_ap.bld 0.40 carfentanil_ab.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tacren carfentanil_ab.bld 1 Blood
  tac2svg -mt="[11C]Carfentanil" -legend=y carfentanil_input.svg -l carfentanil_apc.bld carfentanil_apm.bld carfentanil_ap.bld carfentanil_ab.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f sim1.par ]; then
  rm -f sim1.tac
  printf "# model := 1TCM\n" > sim1.par
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	Vb\n" >> sim1.par
  printf "tac1	0.4	0.6	0\n" >> sim1.par
  printf "tac2	0.3	0.2	0\n" >> sim1.par
fi
if [ ! -f sim1b.par ]; then
  rm -f sim1b.tac
  printf "# model := 1TCM\n" > sim1b.par
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	Vb[mL/mL]	dT[s]\n" >> sim1b.par
  printf "tac1	0.4	0.6	0.05	-10.0\n" >> sim1b.par
  printf "tac2	0.3	0.2	0.04	-15.0\n" >> sim1b.par
fi

if [ ! -f cframes.sif ]; then
  rm -f sim1.tac sim1b.tac
  printf "19/2/2020 19:41:52  31 4 1 TEST1 C-11\n" > cframes.sif
  printf "      0      20       0       0\n" >> cframes.sif
  printf "     20      25       0       0\n" >> cframes.sif
  printf "     25      30       0       0\n" >> cframes.sif
  printf "     30      35       0       0\n" >> cframes.sif
  printf "     35      40       0       0\n" >> cframes.sif
  printf "     40      45       0       0\n" >> cframes.sif
  printf "     45      50       0       0\n" >> cframes.sif
  printf "     50      55       0       0\n" >> cframes.sif
  printf "     55      60       0       0\n" >> cframes.sif
  printf "     60      65       0       0\n" >> cframes.sif
  printf "     65      70       0       0\n" >> cframes.sif
  printf "     70      75       0       0\n" >> cframes.sif
  printf "     75      80       0       0\n" >> cframes.sif
  printf "     80      90       0       0\n" >> cframes.sif
  printf "     90     120       0       0\n" >> cframes.sif
  printf "    120     150       0       0\n" >> cframes.sif
  printf "    150     180       0       0\n" >> cframes.sif
  printf "    180     210       0       0\n" >> cframes.sif
  printf "    210     240       0       0\n" >> cframes.sif
  printf "    240     300       0       0\n" >> cframes.sif
  printf "    300     360       0       0\n" >> cframes.sif
  printf "    360     420       0       0\n" >> cframes.sif
  printf "    420     540       0       0\n" >> cframes.sif
  printf "    540     660       0       0\n" >> cframes.sif
  printf "    660     960       0       0\n" >> cframes.sif
  printf "    960    1260       0       0\n" >> cframes.sif
  printf "   1260    1560       0       0\n" >> cframes.sif
  printf "   1560    2160       0       0\n" >> cframes.sif
  printf "   2160    2760       0       0\n" >> cframes.sif
  printf "   2760    3660       0       0\n" >> cframes.sif
  printf "   3660    4560       0       0\n" >> cframes.sif
fi


if [ ! -f sim1.bld ] || [ ! -f sim1.tac ] || [ ! -f sim1.svg ]; then
  printf "\n simulate TACs \n"
  sim_3tcm -nosub sim1.par carfentanil_apc.bld carfentanil_ab.bld sim1.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  simframe sim1.bld cframes.sif sim1.tac
  printf "\n ok \n"
  tac2svg -mt="SIM1 without Vb or dT" -legend=y sim1.svg -s sim1.tac -l sim1.bld
  printf "\n ok \n"
fi

if [ ! -f sim1b.bld ] || [ ! -f sim1b.tac ] || [ ! -f sim1b.svg ]; then
  printf "\n simulate TACs \n"
  sim_3tcm -vvm=2 -nosub sim1b.par carfentanil_apc.bld carfentanil_ab.bld sim1b.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  simframe sim1b.bld cframes.sif sim1b.tac
  printf "\n ok \n"
  tac2svg -mt="SIM1b with Vb and dT" -legend=y sim1b.svg -s sim1b.tac -l sim1b.bld
  printf "\n ok \n"
fi





if [ ! -f lv.fit ] || [ ! -f lv.bld ]; then
  rm -f sim2.par sim2.tac
  printf "FIT1        fit_wrlv 0.7.2 (c) 2019 by Turku PET Centre\n" > lv.fit
  printf "Date:	2019-08-29 09:33:12\n" >> lv.fit
  printf "Data file:	lv.tac\n" >> lv.fit
  printf "Data unit:	Bq/mL\n" >> lv.fit
  printf "Time unit:	sec\n" >> lv.fit
  printf "Nr of VOIs:	1\n" >> lv.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> lv.fit
  printf "LV . .	0.000	420.000	33	0	8	3331	35	20	4.8E+04	1.6E-03	2.7E+05	5.0E-02	4.0	8.0\n" >> lv.fit
  printf "\n calculate input data for simulations \n"
  fit2dat -c=0,421,1 lv.fit lv.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f sim2.par ]; then
  rm -f sim2.tac
  printf "# model := 1TCM\n" > sim2.par
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	Vb	dT\n" >> sim2.par
  printf "tac1	0.4	0.6	0.03	-23\n" >> sim2.par
  printf "tac2	0.3	0.4	0.04	-20\n" >> sim2.par
fi


if [ ! -f wframes.sif ]; then
  rm -f sim2.tac
  printf "24/8/2019 19:41:52  22 4 1 WAT123 O-15\n" > wframes.sif
  printf "      0      20       0       0\n" >> wframes.sif
  printf "     20      25       0       0\n" >> wframes.sif
  printf "     25      30       0       0\n" >> wframes.sif
  printf "     30      35       0       0\n" >> wframes.sif
  printf "     35      40       0       0\n" >> wframes.sif
  printf "     40      45       0       0\n" >> wframes.sif
  printf "     45      50       0       0\n" >> wframes.sif
  printf "     50      55       0       0\n" >> wframes.sif
  printf "     55      60       0       0\n" >> wframes.sif
  printf "     60      65       0       0\n" >> wframes.sif
  printf "     65      70       0       0\n" >> wframes.sif
  printf "     70      75       0       0\n" >> wframes.sif
  printf "     75      80       0       0\n" >> wframes.sif
  printf "     80      90       0       0\n" >> wframes.sif
  printf "     90     120       0       0\n" >> wframes.sif
  printf "    120     150       0       0\n" >> wframes.sif
  printf "    150     180       0       0\n" >> wframes.sif
  printf "    180     210       0       0\n" >> wframes.sif
  printf "    210     240       0       0\n" >> wframes.sif
  printf "    240     300       0       0\n" >> wframes.sif
  printf "    300     360       0       0\n" >> wframes.sif
  printf "    360     420       0       0\n" >> wframes.sif
fi

if [ ! -f sim2.par ] || [ ! -f sim2.bld ] || [ ! -f sim2.tac ] || [ ! -f sim2.svg ]; then
  printf "\n simulate TACs \n"
  sim_3tcm -vvm=2 -nosub sim2.par lv.bld lv.bld sim2.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  simframe sim2.bld wframes.sif sim2.tac
  printf "\n ok \n"
  tac2svg -mt="SIM2 with Vb and dT" -legend=y sim2.svg -l lv.bld -b sim2.tac
  printf "\n ok \n"
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Test with simulated data. \n"
printf " Test case 2: Use frequently sampled input data. \n"
printf " Expected result: Resulting parameters very close to true ones. \n\n"

rm -f output1.svg output1.par
$PROGRAM -svg=output1.svg carfentanil_apc.bld carfentanil_ab.bld sim1.tac output1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#if [ ! -f output1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
#printf "\n ok \n"

#parmatch -p=y -tacnames=y -parnames=y -parunits=y -wss=n -abs=0.002 -rel=1 correct1.par output1.par
#if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
#printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

