#!/bin/bash
#: Title      : test_fit_blddr
#: Date       : 2019-12-01
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_blddr$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f hsd5.tac ] || [ ! -f hsd6.tac ] || [ ! -f hsd7.tac ] || [ ! -f hsd8.tac ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Fit Feng M2S to real TAC with suitable options. \n"
printf " Test case 2: Data in SUV units. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_hsd5_fengm2s.svg output_hsd5_fengm2s.fit
$PROGRAM -model=m2s -wf -start=1 -svg=output_hsd5_fengm2s.svg hsd5.tac output_hsd5_fengm2s.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output_hsd5_fengm2s.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=hsd5.tac -i output_hsd5_fengm2s.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=3 hsd5.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
# Plot estimated AIF
fit2dat -a=60 output_hsd5_fengm2s.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Estimated AIF" -legend=n output_hsd5_aif_fengm2s.svg -l output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Fit Feng M2 to real TAC with suitable options. \n"
printf " Test case 2: Data in SUV units. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_hsd5_fengm2.svg output_hsd5_fengm2.fit
$PROGRAM -model=m2 -wf -start=1 -svg=output_hsd5_fengm2.svg hsd5.tac output_hsd5_fengm2.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output_hsd5_fengm2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=hsd5.tac -i output_hsd5_fengm2.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=3 hsd5.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
# Plot estimated AIF
fit2dat -a=60 output_hsd5_fengm2.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Estimated AIF" -legend=n output_hsd5_aif_fengm2.svg -l output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Fit LATEFDG to real TAC with suitable options. \n"
printf " Test case 2: Data in SUV units. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_m2s.svg output_hsd5_latefdg.fit
$PROGRAM -model=LATEFDG -wf -start=1 -svg=output_hsd5_latefdg.svg hsd5.tac output_hsd5_latefdg.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output_hsd5_latefdg.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=hsd5.tac -i output_hsd5_latefdg.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=3 hsd5.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
# Plot estimated AIF
fit2dat -a=60 output_hsd5_latefdg.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Estimated AIF" -legend=n output_hsd5_aif_latefdg.svg -l output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: Fit Feng M2S to three real TACs with suitable options. \n"
printf " Test case 2: Data in kBq/mL. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_m2s.svg

$PROGRAM -model=M2S -wf -start=1 hsd6.tac output_hsd6.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=hsd6.tac -i output_hsd6.fit output_hsd6.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=200 -rel=5 hsd6.tac output_hsd6.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -model=M2S -wf -start=1 hsd7.tac output_hsd7.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=hsd7.tac -i output_hsd7.fit output_hsd7.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=200 -rel=5 hsd7.tac output_hsd7.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -model=M2S -wf -start=1 hsd8.tac output_hsd8.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=hsd8.tac -i output_hsd8.fit output_hsd8.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=200 -rel=5 hsd8.tac output_hsd8.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

# Plots fits
tac2svg -mt="Fitted bladder TACs" -legend=y output_m2s.svg -s hsd6.tac -l output_hsd6.tac -s hsd7.tac -l output_hsd7.tac -s hsd8.tac -l output_hsd8.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

# Plot estimated AIFs
fit2dat -a=60 output_hsd6.fit output_hsd6i.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -a=60 output_hsd7.fit output_hsd7i.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -a=60 output_hsd8.fit output_hsd8i.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -mt="Estimated AIFs" -legend=y output_aif_m2s.svg -l output_hsd?i.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

