#!/bin/bash
#: Title      : test_fit_dexp
#: Date       : 2020-01-22
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_dexp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f pk.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Actual plasma PK TAC. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f pk.fit pk.svg output.dat
$PROGRAM -wf -svg=pk.svg pk.dat pk.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f pk.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=pk.dat pk.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=10 pk.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: TAC does not start from peak. \n"
printf " Expected result: reasonable fit is obtained only when fit starts from peak. \n\n"

tacadd0 pk.dat pk0.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f pk0.fit pk0.svg output0.dat

$PROGRAM -wf -svg=pk0.svg pk0.dat pk0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f pk0.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=pk.dat pk0.fit output0.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=10 pk.dat output0.dat
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -peak -wf -svg=pk0.svg pk0.dat pk0.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f pk0.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=pk.dat pk0.fit output0.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=10 pk.dat output0.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Start one after peak. \n"
printf " Test case 2: Save as parameter file. \n"
printf " Expected result: Correct fit start time. \n\n"

rm -f output.par

$PROGRAM -peak1 -wf pk0.dat output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.par ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.par fit_start 0.08333
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Set the number of exponentials to 2. \n"
printf " Expected result: Only two exponentials are fitted. \n\n"

rm -f output.par

$PROGRAM -peak1 -wf -2 -svg=output_2e.svg pk0.dat output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.par ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model 2exp
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Fit monoexponential plus baseline. \n"
printf " Expected result: Monoexponential plus baseline are fitted. \n\n"

rm -f output.par

$PROGRAM -d3 -peak1 -wf -1BL -svg=output_monobaseline.svg pk0.dat output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.par ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model 2exp
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=IFT output.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.ift k1 0
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

