#!/bin/bash
#: Title      : test_tacslope
#: Date       : 2019-08-21
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None
#: ToDo       : Test all options.

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../tacslope$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f slope.dat ] || [ ! -f correct_output.dat]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Reasonable data, sample number set to 5. \n"
printf " Expected result 1: Correct parameters saved. \n"
printf " Expected result 2: Correct means in stdout. \n\n"

rm -f output.par stdout.txt

$PROGRAM -n=5 slope.dat output.par > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

parformat -f=ift output.par
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 output.ift Ta 3.8
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift Ta 2.4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 output.ift sMax 10
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift sMax 1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval -abs=0.001 stdout.txt Ta 3.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt sMax 5.5
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n\n 1.0.1 \n"
printf " Test case: Parameter file not given. \n"
printf " Expected result: Correct means in stdout. \n\n"

rm -f stdout.txt

$PROGRAM -n=5 slope.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.001 stdout.txt Ta 3.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt sMax 5.5
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n\n 1.1.0 \n"
printf " Test case: Option rmbkg. \n"
printf " Expected result: Values before Ta are set to zero. \n\n"

cp -f slope.dat temp.dat

$PROGRAM -n=5 -rmbkg temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct_output.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
