#!/bin/bash
#: Title      : test_avgttac
#: Date       : 2016-03-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../avgttac$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f tissue1.dft ] || [ ! -f tissue2.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f tissue3.dft ] || [ ! -f tissue4.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_mean.dft ] || [ ! -f correct_sd.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Default settings with four files given with wildcard. \n"
printf " Expected result: Correct means saved. \n\n"

rm -f output.dft

$PROGRAM output.dft tissue?.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_mean.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.0.1 \n"
printf " Test case: Default settings with filenames given in file. \n"
printf " Expected result: Correct means saved. \n\n"

ls tissue?.dft > filelist.txt
rm -f output.dft

$PROGRAM output.dft filelist.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_mean.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.0 \n"
printf " Test case 1: Four files given as arguments. \n"
printf " Test case 2: SD saved with option. \n"
printf " Expected result: Correct means and SDs saved. \n\n"

rm -f output.dft output_sd.dft

$PROGRAM -sd=output_sd.dft output.dft tissue1.dft tissue2.dft tissue3.dft tissue4.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_mean.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.1 correct_sd.dft output_sd.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
