#!/bin/bash
#: Title      : test_tacblend
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacblend$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n making test data \n"

if [ ! -f data1.dat ]; then
  printf "0 0\n1 1\n" > data1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data2.dat ]; then
  printf "2 2\n3 3\n" > data2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data3.dat ]; then
  printf "4 40\n" > data3.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data4.dat ]; then
  printf "# timeunit := min\n4 40\n" > data4.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data5.dat ]; then
  printf "# unit := bq/ml\n4 40\n" > data5.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data6.dat ]; then
  printf "# timeunit := min\n# unit := bq/ml\n4 40\n" > data6.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data1.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data1.tac
  printf "2.0    7.0                3.0    2.0     1.0\n" >> data1.tac
  printf "230.0  260.0              9.0    8.0     7.0\n" >> data1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data2.tac ]; then
  printf "start[seconds] end[bq/cc] Makara  Nakki  Aladobi\n" > data2.tac
  printf "8.0    12.0                3.0    4.0     2.0\n" >> data2.tac
  printf "12.0   26.0                4.0    5.0     3.0\n" >> data2.tac
  printf "27.0   37.0                5.0    6.0     4.0\n" >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct_pmod.tac ]; then
  printf "start[seconds] end[bq/cc]  Aladobi Makara Nakki\n" > correct_pmod.tac
  printf "2.0     7.0                1.0    2.0     3.0\n"  >> correct_pmod.tac
  printf "8.0    12.0                2.0    3.0     4.0\n"  >> correct_pmod.tac
  printf "12.0   26.0                3.0    4.0     5.0\n"  >> correct_pmod.tac
  printf "27.0   37.0                4.0    5.0     6.0\n"  >> correct_pmod.tac
  printf "230.0 260.0                7.0    8.0     9.0\n"  >> correct_pmod.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case 1: Three files, one TAC in each, no units. \n"
printf " Expected result: Correctly pooled and sorted. \n\n"

rm -f output.dat correct_output.dat
cat data1.dat > correct_output.dat
cat data2.dat >> correct_output.dat
cat data3.dat >> correct_output.dat

$PROGRAM output.dat data2.dat data1.dat data3.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.1 \n"
printf " Test case 1: Three files, one TAC in each, one file has time units. \n"
printf " Expected result: Correctly pooled and sorted with option --force. \n\n"

rm -f output.dat correct_output.dat
cat data1.dat > correct_output.dat
cat data2.dat >> correct_output.dat
cat data3.dat >> correct_output.dat

$PROGRAM output.dat data2.dat data1.dat data4.dat
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM --force output.dat data2.dat data1.dat data4.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.2 \n"
printf " Test case 1: Three files, one TAC in each, one file has conc units. \n"
printf " Expected result: Correctly pooled and sorted with option --force. \n\n"

rm -f output.dat correct_output.dat
cat data1.dat > correct_output.dat
cat data2.dat >> correct_output.dat
cat data3.dat >> correct_output.dat

$PROGRAM output.dat data2.dat data1.dat data5.dat
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM --force output.dat data2.dat data1.dat data5.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.3 \n"
printf " Test case 1: Same file three times, one TAC in each, contains units. \n"
printf " Expected result: Correctly pooled. \n\n"

rm -f output.dat correct_output.dat
cat data3.dat >  correct_output.dat
cat data3.dat >> correct_output.dat
cat data3.dat >> correct_output.dat

$PROGRAM output.dat data6.dat data6.dat data6.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=n -yunit=n correct_output.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"

printf "\n\n 1.1.0 \n"
printf " Test case 1: Different TAC nr in files. \n"
printf " Expected result: Error. \n\n"

rm -f output.dat stdout.txt
tacadd -ovr temp.dat data2.dat
tacadd      temp.dat data2.dat

$PROGRAM output.dat data1.dat data3.dat temp.dat 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "different number of TACs."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n-----------------------------------------------------------------\n\n"

printf "\n\n 1.2.0 \n"
printf " Test case 1: PMOD format with frame start and end times. \n"
printf " Test case 2: TAC names are not in the same order. \n"
printf " Expected result: Correctly pooled. \n\n"

rm -f output.tac

$PROGRAM output.tac data1.tac data2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -yunit=y correct_pmod.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.2.1 \n"
printf " Test case 1: PMOD format. \n"
printf " Test case 2: Units need to and can be converted. \n"
printf " Expected result: Correctly pooled. \n\n"

rm -f output.tac
cp -f data2.tac data2b.tac
tacunit -xconv=min -yconv=kBq/cc data2b.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM output.tac data1.tac data2b.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -yunit=y -abs=0.01 correct_pmod.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"

printf "\n\n 2.0.0 \n"
printf " Test case: Output filename accidentally given as the last argument. \n"
printf " Expected result: Error, if output file does not exist. \n\n"

rm -f output.tac

$PROGRAM data1.dat data2.dat data3.dat output.dat 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "input file output.dat does not exist."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
