#!/bin/bash
#: Title      : test_taccut
#: Date       : 2020-01-23
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../taccut$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f data.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f data_1_1_1.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f data_1_1_2.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f data_1_1_3.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

printf "\n creating test data \n"

if [ ! -f input.bld ]; then
  printf "time[minutes]	plasma[Bq/cc]\n" > input.bld
  printf "0.15	4.143\n" >> input.bld
  printf "0.44	101.2\n" >> input.bld
  printf "0.88	8932\n"  >> input.bld
  printf "1.07	34278\n" >> input.bld
  printf "1.38	96893\n" >> input.bld
  printf "1.65	110345\n" >> input.bld
  printf "1.98	38777\n" >> input.bld
  printf "2.34	34588\n" >> input.bld
  printf "3.11	30223\n" >> input.bld
  printf "3.72	29354\n" >> input.bld
  printf "4.26	21078\n" >> input.bld
  printf "4.89	18455\n" >> input.bld
  printf "5.24	16221\n" >> input.bld
  printf "6.10	12287\n" >> input.bld
  printf "6.90	12301\n" >> input.bld
  printf "7.56	11056\n" >> input.bld
  printf "8.32	10332\n" >> input.bld
  printf "9.67	8366\n" >> input.bld
  printf "10.22	6981\n" >> input.bld
  printf "15.13	7011\n" >> input.bld
  printf "21.04	5234\n" >> input.bld
  printf "30.21	5125\n" >> input.bld
fi

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 Extract mid time range from the TACs\n\n"

rm -f test.dft test2.dft
cp -f data.dft test.dft
$PROGRAM test.dft 100 300 test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.1 data_1_1_1.dft test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 The same result if input file is edited \n\n"

rm -f test.dft test2.dft
cp -f data.dft test.dft
$PROGRAM test.dft 100 300
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.1 data_1_1_1.dft test.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 2.0.0 Extract early time range from the TACs \n\n"

rm -f test.dft test2.dft
cp -f data.dft test.dft
$PROGRAM test.dft 1 90 test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.1 data_1_1_2.dft test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 3.0.0 Extract end time range from the TACs \n\n"

rm -f test.dft test2.dft
cp -f data.dft test.dft
$PROGRAM test.dft 400 9999999 test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.1 data_1_1_3.dft test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 4.0.0 Extract the whole time range from the TACs \n\n"

rm -f test.dft test2.dft
cp -f data.dft test.dft
$PROGRAM test.dft 0 9999999 test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.1 data.dft test2.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 5.0.0 \n"
printf " Test case 1: Extract the last sample. \n"
printf " Test case 2: File contains frame start and end times. \n"
printf " Expected result: last sample is extracted. \n\n"

rm -f output.dft
$PROGRAM data.dft 420 480 test.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -LS data.dft 0 0 output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.01 test.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.0.1 \n"
printf " Test case 1: Extract the last sample. \n"
printf " Test case 2: File contains frame middle time. \n"
printf " Expected result: last sample is extracted. \n\n"

tacformat -f=pmod -mid data.dft data.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f output.bld
$PROGRAM data.bld 420 480 test.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -LS data.bld 0 0 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.01 test.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.1.0 \n"
printf " Test case: Extract samples up to peak. \n"
printf " Expected result: Correct range is extracted. \n\n"

rm -f output.bld
$PROGRAM input.bld 0 1.7 test.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -uptopeak input.bld 0 0 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.01 test.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.2.0 \n"
printf " Test case: Extract samples from peak. \n"
printf " Expected result: Correct range is extracted. \n\n"

rm -f output.bld
$PROGRAM input.bld 1.6 9999 test.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -frompeak input.bld 0 0 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.01 -rel=0.01 test.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
