#!/bin/bash
#: Title      : test_taccuty
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../taccuty$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f data.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f correct110.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f correct120.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f correct130.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: All data is inside the range. \n"
printf " Test case 2: New filename given. \n"
printf " Expected result: All data is copied to new file. \n"

rm -f output.dft
$PROGRAM data.dft 0 9999 output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: All data is inside the range. \n"
printf " Test case 2: New filename not given. \n"
printf " Expected result: Original data not modified. \n"

$PROGRAM output.dft 0 9999
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case 1: Lower range cuts off first frame and some samples. \n"
printf " Test case 2: New filename given. \n"
printf " Expected result: Correct output file saved. \n"

rm -f output.dft
$PROGRAM data.dft 4 9999 output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct110.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Lower range cuts off first frame and some samples. \n"
printf " Test case 2: New filename not given. \n"
printf " Expected result: Original files correctly modified. \n"

cp -f data.dft output.dft
$PROGRAM output.dft 4 9999
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct110.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Upper range cuts off some samples. \n"
printf " Expected result: Correct output file saved. \n"

rm -f output.dft
$PROGRAM data.dft 0 170 output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct120.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Lower and Upper range cuts off some frames and samples. \n"
printf " Expected result: Correct output file saved. \n"

rm -f output.dft
$PROGRAM data.dft 4 20 output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct130.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 1.4.0 Lower and Upper range cut off all data \n\n"
printf " Expected result: Error. \n"
rm -f output.dft
$PROGRAM data.dft 9000 9500 output.dft 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "no data inside the range."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
