#!/bin/bash
#: Title      : test_tacdel
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacdel$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile1.tac tacname1
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.1\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM tacname1
printf "passed.\n\n"

printf "\n-------------------------------------------------------------------\n"
printf "\n1.0.0\n"

printf "Delete 2 TACs with certain plane number\n"

cp -f tacdel.dft test.dft
$PROGRAM test.dft Pl06
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 tacdel_correct1.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.1\n"

printf "Trying it again will lead to error since TACs will not exist\n"

$PROGRAM test.dft Pl06 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
iftisval stdout.txt Error "specified TACs not found in test.dft."
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.3\n"

printf "With option -dry nothing is actually changed.\n"

cp -f tacdel.dft test.dft
$PROGRAM -dry test.dft Pl06
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 tacdel.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n-------------------------------------------------------------------\n"
printf "\n1.1.0\n"

printf "Delete 5 first TACs by number, leaving only the sixth\n"

cp -f tacdel.dft test.dft
$PROGRAM test.dft 1 2 3 4 5
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 tacdel_correct2.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
