#!/bin/bash
#: Title      : test_tacframe
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacframe$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f test_basic.dft ] || [ ! -f test_basic.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test_zeroes.sif ] || [ ! -f correct_stdout.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f simple.dat ] || [ ! -f correct_simple.sif ]; then
  rm -f simple.dat correct_simple.sif

  printf "1 0\n3 100\n5 110\n7 120\n10 130\n" > simple.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "# timeunit := min\n" >> simple.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

  printf "1/1/1970 00:00:00 5 2 1\n" > correct_simple.sif
  printf "0 120\n" >> correct_simple.sif 
  printf "120 240\n" >> correct_simple.sif
  printf "240 360\n" >> correct_simple.sif
  printf "360 480\n" >> correct_simple.sif
  printf "480 720\n" >> correct_simple.sif
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile1.tac
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.1\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM
printf "passed.\n\n"

printf "\n-------------------------------------------------------------------\n"
printf "\n1.0.0\n"

printf "Print frame times on screen\n"

rm -f stdout.txt
$PROGRAM test_basic.dft 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.1 -rel=1 correct_stdout.txt stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"
printf "\n2.0.0\n"

printf "Save frame times in SIF\n"

rm -f temp.sif
cp -f test_basic.dft temp.dft

$PROGRAM test_basic.dft temp.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f temp.sif ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n2.0.1\n"

printf "Read frame times in SIF\n"

$PROGRAM temp.dft test_zeroes.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n -abs=0.1 -rel=1 test_basic.dft temp.dft
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.2\n"

printf "Set frame times\n"

$PROGRAM temp.dft temp.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -tacnames=y -xunit=y -yunit=y -abs=0.1 -rel=1 test_basic.dft temp.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"
printf "\n2.1.0\n"

printf "Save frame times in SIF when input file contains only mid times\n"

rm -f output.sif
cp -f simple.dat temp.dat

$PROGRAM temp.dat output.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.sif ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_simple.sif output.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
