#!/bin/bash
#: Title      : test_tacinv
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacinv$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f data1.dat ] || [ ! -f correct_output1.dat ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f data2.dat ] || [ ! -f correct_output2.dat ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 Invert works with decent data \n\n"

rm -f test.dat output1.dat
cp -f data1.dat test.dat

$PROGRAM test.dat output1.dat 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output1.dat output1.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 Invert works with data containing bad values \n\n"

rm -f test.dat output2.dat
cp -f data2.dat test.dat

$PROGRAM test.dat output2.dat 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_output2.dat output2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
