#!/bin/bash
#: Title      : test_tacjoin
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacjoin$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n making test data \n"

if [ ! -f data1.dat ]; then
  printf "0 0\n1 1\n" > data1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data2.dat ]; then
  printf "2 2\n3 3\n" > data2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data3.dat ]; then
  printf "4 40\n" > data3.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data1.tac ]; then
  printf "start[seconds]	end[bq/cc]	Nakki	Makara	Aladobi\n" > data1.tac
  printf "2.0	7.0	3.0	2.0	1.0\n" >> data1.tac
  printf "230.0	260.0	9.0	8.0	7.0\n" >> data1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data2.tac ]; then
  printf "start[seconds]	end[bq/cc]	Makara	Nakki	Aladobi\n" > data2.tac
  printf "8.0	12.0	3.0	4.0	2.0\n" >> data2.tac
  printf "12.0	26.0	4.0	5.0	3.0\n" >> data2.tac
  printf "27.0	37.0	5.0	6.0	4.0\n" >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct_pmod.tac ]; then
  printf "time[seconds]	Nakki[bq/cc]	Makara	Aladobi	Makara	Nakki	Aladobi\n" > correct_pmod.tac
  printf "4.5	3	2	1			\n"  >> correct_pmod.tac
  printf "245	9	8	7			\n"  >> correct_pmod.tac
  printf "10				3	4	2\n"  >> correct_pmod.tac
  printf "19				4	5	3\n"  >> correct_pmod.tac
  printf "32				5	6	4\n"  >> correct_pmod.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Very simple files, all with different times. \n"
printf " Expected result: Correctly joined. \n\n"

rm -f output.dat
if [ ! -f correct100.dat ]; then
  printf "0.00000 0.000000e+00 . .\n"  > correct100.dat
  printf "1.00000 1.000000e+00 . .\n" >> correct100.dat
  printf "2.00000 . 2.000000e+00 .\n" >> correct100.dat
  printf "3.00000 . 3.000000e+00 .\n" >> correct100.dat
  printf "4.00000 . . 4.000000e+01\n" >> correct100.dat
fi

$PROGRAM output.dat data1.dat data2.dat data3.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct100.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.1 \n"
printf " Test case: Very simple files, same times. \n"
printf " Expected result: Correctly joined. \n\n"

rm -f output.dat
if [ ! -f correct101.dat ]; then
  printf "2 2 2\n"  > correct101.dat
  printf "3 3 3\n" >> correct101.dat
fi

$PROGRAM output.dat data2.dat data2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct101.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.0 \n"
printf " Test case 1: PMOD files with TAC names. \n"
printf " Test case 2: different times, frame start and end times. \n"
printf " Expected result: Correctly joined. \n\n"

rm -f output.tac

$PROGRAM output.tac data1.tac data2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_pmod.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.1 \n"
printf " Test case: different but convertible units. \n"
printf " Expected result: Correctly joined. \n\n"

cp -f data2.tac temp.tac
tacunit -xconv=min -yconv=kBq/mL temp.tac
rm -f output.tac

$PROGRAM output.tac data1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct_pmod.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.2.0 \n"
printf " Test case: mixed formats. \n"
printf " Expected result: Correctly joined with force option. \n\n"

rm -f output.tac

$PROGRAM output.tac data1.tac data1.dat 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "non-compatible TAC units."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM --force output.tac data1.tac data1.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM output.dat data1.dat data1.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "non-compatible TAC units."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM --force output.dat data1.dat data1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
