#!/bin/bash
#: Title      : test_taclist
#: Date       : 2019-11-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../taclist$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f test1.tac ]; then
  printf "start[seconds]	end[kBq/cc]	voi1	voi2	head\n" >  test1.tac
  printf "0.00000	30.00000	3.000000e+00	2.000000e+00	1.000000e+00\n" >>  test1.tac
  printf "30.00000	60.00000	5.000000e+02	8.000000e+01	3.000000e+01\n" >>  test1.tac
  printf "60.00000	120.00000	2.000000e+02	4.000000e+01	5.000000e+02\n" >>  test1.tac
  printf "# studynr := test001\n" >>  test1.tac
fi

if [ ! -f test2.tac ]; then
  printf "start[seconds]	end[kBq/cc]	voi1	voi2	head	weight\n" >  test2.tac
  printf "0.00000	30.00000	3.000000e+00	2.000000e+00	1.000000e+00	100\n" >>  test2.tac
  printf "30.00000	60.00000	5.000000e+02	8.000000e+01	3.000000e+01	90\n" >>  test2.tac
  printf "60.00000	120.00000	2.000000e+02	4.000000e+01	5.000000e+02	50\n" >>  test2.tac
  printf "# studynr := test001\n" >>  test2.tac
fi




printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: List a TAC file without options. \n"
printf " Expected result: No error. \n\n"

$PROGRAM test1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"


printf "\n 1.1.0 \n"
printf " Test case: List a TAC file as IFT. \n"
printf " Expected result: Correct IFT listed. \n\n"

$PROGRAM -ift test1.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacNr 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift volume[2] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][3] 500
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"


printf "\n 1.1.1 \n"
printf " Test case: Option -nv. \n"
printf " Expected result: Volumes are not listed. \n\n"

$PROGRAM -ift -nv test1.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift volume[1]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift volume[2]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

iftisval output.ift tacNr 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][3] 500
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"


printf "\n 1.1.2 \n"
printf " Test case: Option -na. \n"
printf " Expected result: Activities are not listed. \n\n"

$PROGRAM -ift -na test1.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift value[1][1]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][3]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

iftisval output.ift tacNr 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"


printf "\n 1.1.3 \n"
printf " Test case: Option -nn. \n"
printf " Expected result: TAC names are not listed. \n\n"

$PROGRAM -ift -nn test1.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift value[1][1]
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] voi1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"



printf "\n 1.1.4 \n"
printf " Test case: List just one TAC as IFT. \n"
printf " Expected result: Correct TAC listed. \n\n"

$PROGRAM -ift test1.tac voi2 > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift tacname[1]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[3]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[2] voi2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

iftisval output.ift tacNr 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[1][2]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[2][2] 80
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][2]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"




printf "\n 1.2.0 \n"
printf " Test case: List weights that do not exist. \n"
printf " Expected result: Program tells that there are no weights but lists everything else. \n\n"

$PROGRAM -ift -weights test1.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift weights no
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

iftisval output.ift tacNr 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift volume[2] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][3] 500
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"


printf "\n 1.2.1 \n"
printf " Test case: List weights that do exist. \n"
printf " Expected result: Weights and everything else is listed. \n\n"

$PROGRAM -ift -weights test2.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift weights yes
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weight[1] 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weight[2] 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weight[3] 50
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

iftisval output.ift tacNr 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift volume[2] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][3] 500
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"



printf "\n 1.2.2 \n"
printf " Test case: List weights but no volumes or activities. \n"
printf " Expected result: Weights are listed. \n\n"

$PROGRAM -ift -weights -nv -na test2.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift weights yes
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weight[1] 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weight[2] 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift weight[3] 50
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

iftisval output.ift volume[1]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][2]
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
