#!/bin/bash
#: Title      : test_tacln
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacln$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f data1.tac ] || [ ! -f data1.bld ]; then
  printf "\n making test data \n"
  printf "start[minutes]\tend[Bq/cc]\ttac1\ttac2\n" > data1.tac
  printf "0.0\t1.0\t-1.23E-03\t1.023E-80\n" >> data1.tac
  printf "1.0\t2.0\t2.34E+00\t3.23E+01\n" >> data1.tac
  printf "2.0\t3.0\t3.00E+01\t4.5E+03\n" >> data1.tac
  tacformat -mid -f=PMOD data1.tac data1.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f correct_y.tac ] || [ ! -f correct_y.bld ]; then
  printf "\n making comparison data y \n"
  printf "start[minutes]\tend[Bq/cc]\ttac1\ttac2\n" > correct_y.tac
  printf "0.0\t1.0\t.\t.\n"                        >> correct_y.tac
  printf "1.0\t2.0\t8.501509e-01\t3.475067e+00\n"  >> correct_y.tac
  printf "2.0\t3.0\t3.401197e+00\t8.411833e+00\n"  >> correct_y.tac
  tacformat -mid -f=PMOD correct_y.tac correct_y.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f correct_xy.tac ] || [ ! -f correct_xy.bld ]; then
  printf "\n making comparison data xy \n"
  printf "start[minutes]\tend[Bq/cc]\ttac1\ttac2\n"         > correct_xy.tac
  printf ".\t0.0\t.\t.\n"                                  >> correct_xy.tac
  printf "0.0\t0.69315\t8.501509e-01\t3.475067e+00\n"      >> correct_xy.tac
  printf "0.69315\t1.09861\t3.401197e+00\t8.411833e+00\n"  >> correct_xy.tac

  printf "time[minutes]\ttac1[Bq/cc]\ttac2\n"        > correct_xy.bld
  printf -- "-0.69315\t.\t.\n"                      >> correct_xy.bld
  printf "0.4054651\t8.501509e-01\t3.475067e+00\n"  >> correct_xy.bld
  printf "0.9162907\t3.401197e+00\t8.411833e+00\n"  >> correct_xy.bld

  printf "\n ok \n"
fi

if [ ! -f correct_x.tac ] || [ ! -f correct_x.bld ]; then
  printf "\n making comparison data x \n"
  printf "start[minutes]\tend[Bq/cc]\ttac1\ttac2\n"  > correct_x.tac
  printf ".\t0.0\t-1.23E-03\t1.023E-80\n"           >> correct_x.tac
  printf "0.0\t0.69315\t2.34E+00\t3.23E+01\n"       >> correct_x.tac
  printf "0.69315\t1.09861\t3.00E+01\t4.5E+03\n"    >> correct_x.tac

  printf "time[minutes]\ttac1[Bq/cc]\ttac2\n"    > correct_x.bld
  printf -- "-0.69315\t-1.23E-03\t1.023E-80\n"  >> correct_x.bld
  printf "0.4054651\t2.34E+00\t3.23E+01\n"      >> correct_x.bld
  printf "0.9162907\t3.00E+01\t4.5E+03\n"       >> correct_x.bld

  printf "\n ok \n"
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Decent data, no options, PMOD TAC data. \n"
printf " Expected result 1: y values are correctly transformed. \n"
printf " Expected result 2: values that cannot be log transformed are set to NaN. \n\n"

rm -f output.tac
$PROGRAM data1.tac output.tac 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=1.0E-04 correct_y.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Decent data, no options, PMOD BLD data. \n"
printf " Expected result 1: y values are correctly transformed. \n"
printf " Expected result 2: values that cannot be log transformed are set to NaN. \n\n"

rm -f output.bld
$PROGRAM data1.bld output.bld 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=1.0E-04 correct_y.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.1.0 \n"
printf " Test case: Decent data, option -x=y, PMOD TAC data. \n"
printf " Expected result 1: both x and y values are correctly transformed. \n"
printf " Expected result 2: values that cannot be log transformed are set to NaN. \n\n"

rm -f output.tac
$PROGRAM -x=y data1.tac output.tac 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=1.0E-04 correct_xy.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Decent data, option -x=y, PMOD BLD data. \n"
printf " Expected result 1: y values are correctly transformed. \n"
printf " Expected result 2: values that cannot be log transformed are set to NaN. \n\n"

rm -f output.bld
$PROGRAM -X=Yes data1.bld output.bld 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=1.0E-04 correct_xy.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.2.0 \n"
printf " Test case: Decent data, options -x=y -y=n, PMOD TAC data. \n"
printf " Expected result 1: both x and y values are correctly transformed. \n"
printf " Expected result 2: values that cannot be log transformed are set to NaN. \n\n"

rm -f output.tac
$PROGRAM -x=y -y=no data1.tac output.tac 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=1.0E-04 correct_x.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Decent data, options -x=y -y=n, PMOD BLD data. \n"
printf " Expected result 1: y values are correctly transformed. \n"
printf " Expected result 2: values that cannot be log transformed are set to NaN. \n\n"

rm -f output.bld
$PROGRAM -x=y -Y=No data1.bld output.bld 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=1.0E-04 correct_x.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
