#!/bin/bash
#: Title      : test_tacp2f
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacp2f$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

rm -f data1.dat data2.dat
printf "5 98\n"  >  data1.dat
printf "10 87\n" >> data1.dat
printf "15 76\n" >> data1.dat
printf "20 69\n" >> data1.dat
taccalc data1.dat x 0.01 data2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf "Test case: Data in percentages \n"
printf "Excepted result: Output data in fractions. \n\n"

rm -f output1.dat

$PROGRAM data1.dat output1.dat 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data2.dat output1.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.0 \n"
printf "Test case: Data in fractions \n"
printf "Excepted result: Output data still in fractions. \n\n"

rm -f output2.dat

$PROGRAM data2.dat output2.dat 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data2.dat output2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.2.0 \n"
printf "Test case: Output file name not given \n"
printf "Excepted result: Input file modified. \n\n"

cp -f data1.dat temp.dat

$PROGRAM temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data2.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
