#!/bin/bash
#: Title      : test_tacsetx
#: Date       : 2019-11-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacsetx$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

# printf "\n verifying that required data exists \n"

printf "\n making test data \n"

if [ ! -f test1.dat ] || [ ! -f test2.dat ]; then
  rm -f test1.dat test2.dat test1.tac test2.tac
  printf "0 1 2\n0 1 2\n0 1 2\n0 1 2\n0 1 2\n" >> test1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "0 1 2 3\n0 2 3 4\n0 3 4 5\n0 4 5 6\n0 5 6 7\n" >> test2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_test1.dat ]; then
  printf "1 1 2\n2 1 2\n3 1 2\n4 1 2\n5 1 2\n" >> correct_test1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct_test3.dat ]; then
  rm -f correct_test3.tac
  printf "3 1 2\n4 1 2\n5 1 2\n6 1 2\n7 1 2\n" >> correct_test3.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test1.tac ] || [ ! -f test2.tac ]; then
  tacformat -format=pmod test1.dat test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacformat -format=pmod test2.dat test2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test1.tac 1 one
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test1.tac 2 two
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test2.tac 1 first
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test2.tac 2 second
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test2.tac 3 third
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_test3.tac ]; then
  tacformat -format=pmod correct_test3.dat correct_test3.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren correct_test3.tac 1 one
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren correct_test3.tac 2 two
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f testy.dat ]; then
  printf "2\n3\n4\n5\n6\n" > testy.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_testy.dat ]; then
  printf "1 2\n2 3\n3 4\n4 5\n5 6\n" > correct_testy.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.sif ]; then
  printf "17/11/2019 13:32:51 5 2 1 test2 C-11\n" > test2.sif
  printf "0 2\n" >> test2.sif
  printf "2 4\n" >> test2.sif
  printf "4 6\n" >> test2.sif
  printf "6 10\n" >> test2.sif
  printf "10 20\n" >> test2.sif
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Copy X between simple file formats. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f test1.dat temp.dat

$PROGRAM temp.dat test2.dat 1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_test1.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

cp -f test1.dat temp2.dat
$PROGRAM temp2.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_test1.dat temp2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Copy X from PMOD to simple file format. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f test1.dat temp.dat

$PROGRAM temp.dat test2.tac 1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_test1.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM temp.dat test2.tac first
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_test1.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Copy all frame info from PMOD to simple file format. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f test2.dat temp.dat
cp -f test2.tac temp2.tac
tacframe -mid temp2.tac test2.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM temp.dat temp2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch temp2.tac temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===============================================================\n\n"


printf "\n 1.1.0 \n"
printf " Test case: Copy X between PMOD file formats. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f test1.tac temp.tac

$PROGRAM temp.tac test2.tac 3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y correct_test3.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


cp -f test1.tac temp.tac

$PROGRAM temp.tac test2.tac third
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y correct_test3.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Copy all frame info from PMOD to PMOD file. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f test2.tac temp.tac
cp -f test2.tac temp2.tac
tacframe temp2.tac test2.sif
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM temp.tac temp2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch temp2.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===============================================================\n\n"


printf "\n 1.2.0 \n"
printf " Test case: Copy X from simple format to PMOD format. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f test1.tac temp.tac

$PROGRAM temp.tac test2.dat 3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y correct_test3.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===============================================================\n\n"


printf "\n 1.3.0 \n"
printf " Test case: Simple file contains just one column. \n"
printf " Expected result: Result file contents are correct. \n"

cp -f testy.dat temp.dat

$PROGRAM temp.dat test2.dat 1 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_testy.dat temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
